/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.operation.AbstractOperation;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuitOperation
extends AbstractOperation<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(QuitOperation.class);

    public QuitOperation() {
        super(new OperationFuture());
        this.command = "quit";
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        try {
            String line = in.getString(charset.newDecoder());
            LOG.debug("command is [{}], reply is [{}]", (Object)this.command, (Object)line);
            this.future.setResult(true);
        }
        catch (CharacterCodingException e) {
            this.future.setException(e);
        }
        return true;
    }
}

