/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.operation.AbstractOperation;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseOperation
extends AbstractOperation<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(ReleaseOperation.class);

    public ReleaseOperation(long id, int priority, int delay) {
        super(new OperationFuture());
        this.command = "release " + id + " " + priority + " " + delay;
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        try {
            String line = in.getString(charset.newDecoder());
            LOG.debug("command is [{}], reply is [{}]", (Object)this.command, (Object)line);
            if (line.startsWith("RELEASED")) {
                this.future.setResult(true);
                return true;
            }
            if (line.startsWith("NOT_FOUND")) {
                this.future.setResult(false);
                return true;
            }
            if (line.startsWith("BURIED")) {
                this.future.setResult(false);
                return true;
            }
            this.exceptionHandler(line);
        }
        catch (Exception e) {
            this.future.setException(e);
        }
        return true;
    }
}

