/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2;

import com.facebook.presto.jdbc.internal.jetty.http2.ErrorCode;
import com.facebook.presto.jdbc.internal.jetty.http2.ISession;
import com.facebook.presto.jdbc.internal.jetty.http2.parser.Parser;
import com.facebook.presto.jdbc.internal.jetty.io.AbstractConnection;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.thread.ExecutionStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class HTTP2Connection
extends AbstractConnection {
    protected static final Logger LOG = Log.getLogger(HTTP2Connection.class);
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private final HTTP2Producer producer = new HTTP2Producer();
    private final AtomicLong bytesIn = new AtomicLong();
    private final ByteBufferPool byteBufferPool;
    private final Parser parser;
    private final ISession session;
    private final int bufferSize;
    private final ExecutionStrategy executionStrategy;

    public HTTP2Connection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, Parser parser, ISession session, int bufferSize, ExecutionStrategy.Factory executionFactory) {
        super(endPoint, executor);
        this.byteBufferPool = byteBufferPool;
        this.parser = parser;
        this.session = session;
        this.bufferSize = bufferSize;
        this.executionStrategy = executionFactory.newExecutionStrategy(this.producer, executor);
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.get();
    }

    @Override
    public long getBytesOut() {
        return this.session.getBytesWritten();
    }

    public ISession getSession() {
        return this.session;
    }

    protected Parser getParser() {
        return this.parser;
    }

    protected void setInputBuffer(ByteBuffer buffer) {
        this.producer.buffer = buffer;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Open {} ", this);
        }
        super.onOpen();
        this.executionStrategy.execute();
    }

    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Close {} ", this);
        }
        super.onClose();
    }

    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onFillable {} ", this);
        }
        this.executionStrategy.execute();
    }

    private int fill(EndPoint endPoint, ByteBuffer buffer) {
        try {
            if (endPoint.isInputShutdown()) {
                return -1;
            }
            return endPoint.fill(buffer);
        }
        catch (IOException x) {
            LOG.debug("Could not read from " + endPoint, x);
            return -1;
        }
    }

    @Override
    public boolean onIdleExpired() {
        boolean close;
        boolean idle = this.isFillInterested();
        if (idle && (close = this.session.onIdleTimeout())) {
            this.session.close(ErrorCode.NO_ERROR.code, "idle_timeout", Callback.NOOP);
        }
        return false;
    }

    protected void offerTask(Runnable task, boolean dispatch) {
        this.offerTask(task);
        if (dispatch) {
            this.executionStrategy.dispatch();
        } else {
            this.executionStrategy.execute();
        }
    }

    @Override
    public void close() {
        this.session.close(ErrorCode.NO_ERROR.code, "close", Callback.NOOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerTask(Runnable task) {
        HTTP2Connection hTTP2Connection = this;
        synchronized (hTTP2Connection) {
            this.tasks.offer(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable pollTask() {
        HTTP2Connection hTTP2Connection = this;
        synchronized (hTTP2Connection) {
            return this.tasks.poll();
        }
    }

    private class FillCallback
    implements Callback.NonBlocking {
        private FillCallback() {
        }

        @Override
        public void succeeded() {
            HTTP2Connection.this.onFillable();
        }

        @Override
        public void failed(Throwable x) {
            HTTP2Connection.this.onFillInterestedFailed(x);
        }
    }

    protected class HTTP2Producer
    implements ExecutionStrategy.Producer {
        private final Callback fillCallback;
        private ByteBuffer buffer;

        protected HTTP2Producer() {
            this.fillCallback = new FillCallback();
        }

        @Override
        public Runnable produce() {
            Runnable task = HTTP2Connection.this.pollTask();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dequeued task {}", task);
            }
            if (task != null) {
                return task;
            }
            if (HTTP2Connection.this.isFillInterested()) {
                return null;
            }
            if (this.buffer == null) {
                this.buffer = HTTP2Connection.this.byteBufferPool.acquire(HTTP2Connection.this.bufferSize, false);
            }
            boolean looping = BufferUtil.hasContent(this.buffer);
            while (true) {
                if (looping) {
                    while (this.buffer.hasRemaining()) {
                        HTTP2Connection.this.parser.parse(this.buffer);
                    }
                    task = HTTP2Connection.this.pollTask();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Dequeued new task {}", task);
                    }
                    if (task != null) {
                        this.release();
                        return task;
                    }
                }
                int filled = HTTP2Connection.this.fill(HTTP2Connection.this.getEndPoint(), this.buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes", filled);
                }
                if (filled == 0) {
                    this.release();
                    HTTP2Connection.this.getEndPoint().fillInterested(this.fillCallback);
                    return null;
                }
                if (filled < 0) {
                    this.release();
                    HTTP2Connection.this.session.onShutdown();
                    return null;
                }
                HTTP2Connection.this.bytesIn.addAndGet(filled);
                looping = true;
            }
        }

        private void release() {
            if (this.buffer != null && !this.buffer.hasRemaining()) {
                HTTP2Connection.this.byteBufferPool.release(this.buffer);
                this.buffer = null;
            }
        }
    }
}

