/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpReceiver;
import com.facebook.presto.jdbc.internal.jetty.client.HttpResponse;
import com.facebook.presto.jdbc.internal.jetty.http.HttpField;
import com.facebook.presto.jdbc.internal.jetty.http.HttpFields;
import com.facebook.presto.jdbc.internal.jetty.http.HttpStatus;
import com.facebook.presto.jdbc.internal.jetty.http.MetaData;
import com.facebook.presto.jdbc.internal.jetty.http2.ErrorCode;
import com.facebook.presto.jdbc.internal.jetty.http2.api.Stream;
import com.facebook.presto.jdbc.internal.jetty.http2.client.http.HttpChannelOverHTTP2;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.DataFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.HeadersFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.PushPromiseFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.ResetFrame;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.IteratingCallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.Queue;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements Stream.Listener {
    private final ContentNotifier contentNotifier = new ContentNotifier();

    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    public void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse response = exchange.getResponse();
        MetaData.Response metaData = (MetaData.Response)frame.getMetaData();
        response.version(metaData.getVersion()).status(metaData.getStatus()).reason(metaData.getReason());
        if (this.responseBegin(exchange)) {
            HttpFields headers = metaData.getFields();
            for (HttpField header : headers) {
                if (this.responseHeader(exchange, header)) continue;
                return;
            }
            if (this.responseHeaders(exchange)) {
                boolean informational;
                int status = metaData.getStatus();
                boolean bl = informational = HttpStatus.isInformational(status) && status != 101;
                if (frame.isEndStream() || informational) {
                    this.responseSuccess(exchange);
                }
            }
        }
    }

    @Override
    public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    @Override
    public void onData(Stream stream, DataFrame frame, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            callback.failed(new IOException("terminated"));
            return;
        }
        ByteBufferPool byteBufferPool = this.getHttpDestination().getHttpClient().getByteBufferPool();
        ByteBuffer original = frame.getData();
        int length = original.remaining();
        ByteBuffer copy = byteBufferPool.acquire(length, original.isDirect());
        BufferUtil.clearToFill(copy);
        copy.put(original);
        BufferUtil.flipToFlush(copy, 0);
        this.contentNotifier.offer(new DataInfo(exchange, copy, callback, frame.isEndStream()));
        this.contentNotifier.iterate();
    }

    @Override
    public void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        ErrorCode error = ErrorCode.from(frame.getError());
        String reason = error == null ? "reset" : error.name().toLowerCase(Locale.ENGLISH);
        exchange.getRequest().abort(new IOException(reason));
    }

    @Override
    public boolean onIdleTimeout(Stream stream, Throwable x) {
        this.responseFailure(x);
        return true;
    }

    private static class DataInfo {
        private final HttpExchange exchange;
        private final ByteBuffer buffer;
        private final Callback callback;
        private final boolean last;

        private DataInfo(HttpExchange exchange, ByteBuffer buffer, Callback callback, boolean last) {
            this.exchange = exchange;
            this.buffer = buffer;
            this.callback = callback;
            this.last = last;
        }
    }

    private class ContentNotifier
    extends IteratingCallback {
        private final Queue<DataInfo> queue = new ArrayDeque<DataInfo>();
        private DataInfo dataInfo;

        private ContentNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean offer(DataInfo dataInfo) {
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                return this.queue.offer(dataInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IteratingCallback.Action process() throws Exception {
            DataInfo dataInfo;
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                dataInfo = this.queue.poll();
            }
            if (dataInfo == null) {
                DataInfo prevDataInfo = this.dataInfo;
                if (prevDataInfo != null && prevDataInfo.last) {
                    return IteratingCallback.Action.SUCCEEDED;
                }
                return IteratingCallback.Action.IDLE;
            }
            this.dataInfo = dataInfo;
            HttpReceiverOverHTTP2.this.responseContent(dataInfo.exchange, dataInfo.buffer, this);
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        public void succeeded() {
            ByteBufferPool byteBufferPool = HttpReceiverOverHTTP2.this.getHttpDestination().getHttpClient().getByteBufferPool();
            byteBufferPool.release(this.dataInfo.buffer);
            this.dataInfo.callback.succeeded();
            super.succeeded();
        }

        @Override
        protected void onCompleteSuccess() {
            HttpReceiverOverHTTP2.this.responseSuccess(this.dataInfo.exchange);
        }

        @Override
        protected void onCompleteFailure(Throwable failure) {
            ByteBufferPool byteBufferPool = HttpReceiverOverHTTP2.this.getHttpDestination().getHttpClient().getByteBufferPool();
            byteBufferPool.release(this.dataInfo.buffer);
            this.dataInfo.callback.failed(failure);
            HttpReceiverOverHTTP2.this.responseFailure(failure);
        }
    }
}

