/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.parser;

import com.facebook.presto.jdbc.internal.jetty.http.MetaData;
import com.facebook.presto.jdbc.internal.jetty.http2.hpack.HpackDecoder;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import java.nio.ByteBuffer;

public class HeaderBlockParser {
    private final ByteBufferPool byteBufferPool;
    private final HpackDecoder hpackDecoder;
    private ByteBuffer blockBuffer;

    public HeaderBlockParser(ByteBufferPool byteBufferPool, HpackDecoder hpackDecoder) {
        this.byteBufferPool = byteBufferPool;
        this.hpackDecoder = hpackDecoder;
    }

    public MetaData parse(ByteBuffer buffer, int blockLength) {
        ByteBuffer toDecode;
        int accumulated = this.blockBuffer == null ? 0 : this.blockBuffer.position();
        int remaining = blockLength - accumulated;
        if (buffer.remaining() < remaining) {
            if (this.blockBuffer == null) {
                this.blockBuffer = this.byteBufferPool.acquire(blockLength, false);
                BufferUtil.clearToFill(this.blockBuffer);
            }
            this.blockBuffer.put(buffer);
            return null;
        }
        int limit = buffer.limit();
        buffer.limit(buffer.position() + remaining);
        if (this.blockBuffer != null) {
            this.blockBuffer.put(buffer);
            BufferUtil.flipToFlush(this.blockBuffer, 0);
            toDecode = this.blockBuffer;
        } else {
            toDecode = buffer;
        }
        MetaData result = this.hpackDecoder.decode(toDecode);
        buffer.limit(limit);
        if (this.blockBuffer != null) {
            this.byteBufferPool.release(this.blockBuffer);
            this.blockBuffer = null;
        }
        return result;
    }
}

