/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.ArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.ArrayElementBlockWriter;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;

public class ArrayBlockBuilder
extends AbstractArrayBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayBlockBuilder.class).instanceSize() + BlockBuilderStatus.INSTANCE_SIZE;
    private int positionCount;
    private BlockBuilderStatus blockBuilderStatus;
    private int[] offsets;
    private boolean[] valueIsNull;
    private final BlockBuilder values;
    private int currentEntrySize;
    private int retainedSizeInBytes;

    public ArrayBlockBuilder(BlockBuilder valuesBlock, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, valuesBlock, new int[expectedEntries + 1], new boolean[expectedEntries]);
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries, expectedBytesPerEntry), new int[expectedEntries + 1], new boolean[expectedEntries]);
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries), new int[expectedEntries + 1], new boolean[expectedEntries]);
    }

    private ArrayBlockBuilder(BlockBuilderStatus blockBuilderStatus, BlockBuilder values, int[] offsets, boolean[] valueIsNull) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        this.values = Objects.requireNonNull(values, "values is null");
        this.offsets = Objects.requireNonNull(offsets, "offset is null");
        this.valueIsNull = Objects.requireNonNull(valueIsNull, "valueIsNull is null");
        if (offsets.length != valueIsNull.length + 1) {
            throw new IllegalArgumentException("expected offsets and valueIsNull to have same length");
        }
        this.updateDataSize();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        return this.values.getSizeInBytes() + 5 * this.positionCount;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    protected Block getValues() {
        return this.values;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return 0;
    }

    @Override
    protected boolean[] getValueIsNull() {
        return this.valueIsNull;
    }

    @Override
    public BlockBuilder writeObject(Object value) {
        if (this.currentEntrySize != 0) {
            throw new IllegalStateException("Expected entry size to be exactly 0 but was " + this.currentEntrySize);
        }
        Block block = (Block)value;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                this.values.appendNull();
                continue;
            }
            block.writePositionTo(i, this.values);
            this.values.closeEntry();
        }
        ++this.currentEntrySize;
        return this;
    }

    @Override
    public ArrayElementBlockWriter beginBlockEntry() {
        if (this.currentEntrySize != 0) {
            throw new IllegalStateException("Expected current entry size to be exactly 0 but was " + this.currentEntrySize);
        }
        ++this.currentEntrySize;
        return new ArrayElementBlockWriter(this.values, this.values.getPositionCount());
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.currentEntrySize != 1) {
            throw new IllegalStateException("Expected entry size to be exactly 1 but was " + this.currentEntrySize);
        }
        this.entryAdded(false);
        this.currentEntrySize = 0;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        this.offsets[this.positionCount + 1] = this.values.getPositionCount();
        this.valueIsNull[this.positionCount] = isNull;
        ++this.positionCount;
        this.blockBuilderStatus.addBytes(5);
    }

    private void growCapacity() {
        int newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = BlockUtil.intSaturatedCast((long)INSTANCE_SIZE + SizeOf.sizeOf(this.valueIsNull) + SizeOf.sizeOf(this.offsets));
    }

    @Override
    public ArrayBlock build() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return new ArrayBlock(this.positionCount, this.valueIsNull, this.offsets, this.values.build());
    }

    @Override
    public void reset(BlockBuilderStatus blockBuilderStatus) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        int newSize = BlockUtil.calculateBlockResetSize(this.getPositionCount());
        this.valueIsNull = new boolean[newSize];
        this.offsets = new int[newSize + 1];
        this.values.reset(blockBuilderStatus);
        this.currentEntrySize = 0;
        this.positionCount = 0;
        this.updateDataSize();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

