/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.type.Type;

public enum SortOrder {
    ASC_NULLS_FIRST(true, true),
    ASC_NULLS_LAST(true, false),
    DESC_NULLS_FIRST(false, true),
    DESC_NULLS_LAST(false, false);

    private final boolean ascending;
    private final boolean nullsFirst;

    private SortOrder(boolean ascending, boolean nullsFirst) {
        this.ascending = ascending;
        this.nullsFirst = nullsFirst;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isNullsFirst() {
        return this.nullsFirst;
    }

    public int compareBlockValue(Type type, Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftIsNull = leftBlock.isNull(leftPosition);
        boolean rightIsNull = rightBlock.isNull(rightPosition);
        if (leftIsNull && rightIsNull) {
            return 0;
        }
        if (leftIsNull) {
            return this.nullsFirst ? -1 : 1;
        }
        if (rightIsNull) {
            return this.nullsFirst ? 1 : -1;
        }
        int result = type.compareTo(leftBlock, leftPosition, rightBlock, rightPosition);
        return this.ascending ? result : -result;
    }
}

