/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.FixedWidthBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.DecimalType;
import com.facebook.presto.jdbc.internal.spi.type.Decimals;
import com.facebook.presto.jdbc.internal.spi.type.SqlDecimal;

final class LongDecimalType
extends DecimalType {
    private static final int SIGN_BIT_MASK = 128;

    LongDecimalType(int precision, int scale) {
        super(precision, scale, Slice.class);
        this.validatePrecisionScale(precision, scale, 38);
    }

    @Override
    public int getFixedSize() {
        return 16;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new FixedWidthBlockBuilder(this.getFixedSize(), blockBuilderStatus, Math.min(expectedEntries, blockBuilderStatus.getMaxBlockSizeInBytes() / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new FixedWidthBlockBuilder(this.getFixedSize(), positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = block.getSlice(position, 0, this.getFixedSize());
        return new SqlDecimal(Decimals.decodeUnscaledValue(slice), this.getPrecision(), this.getScale());
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return leftBlock.equals(leftPosition, 0, rightBlock, rightPosition, 0, this.getFixedSize());
    }

    @Override
    public long hash(Block block, int position) {
        return block.hash(position, 0, this.getFixedSize());
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        byte right;
        byte left = leftBlock.getByte(leftPosition, 0);
        if ((left & 0x80) != ((right = rightBlock.getByte(rightPosition, 0)) & 0x80)) {
            return Byte.compare(left, right);
        }
        return leftBlock.compareTo(leftPosition, 0, this.getFixedSize(), rightBlock, rightPosition, 0, this.getFixedSize());
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, this.getFixedSize(), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }
}

