/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.compiler.byteCode;

import com.facebook.swift.codec.internal.compiler.byteCode.ParameterizedType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class NamedParameterDefinition {
    private final ParameterizedType type;
    private final String name;

    public static NamedParameterDefinition arg(Class<?> type) {
        return new NamedParameterDefinition(null, ParameterizedType.type(type));
    }

    public static NamedParameterDefinition arg(String name, Class<?> type) {
        return new NamedParameterDefinition(name, ParameterizedType.type(type));
    }

    public static NamedParameterDefinition arg(ParameterizedType type) {
        return new NamedParameterDefinition(null, type);
    }

    public static NamedParameterDefinition arg(String name, ParameterizedType type) {
        return new NamedParameterDefinition(name, type);
    }

    NamedParameterDefinition(String name, ParameterizedType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NamedParameterDefinition");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    public static Function<NamedParameterDefinition, ParameterizedType> getNamedParameterType() {
        return new Function<NamedParameterDefinition, ParameterizedType>(){

            public ParameterizedType apply(NamedParameterDefinition input) {
                Preconditions.checkNotNull((Object)input);
                return input.getType();
            }
        };
    }
}

