/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftMethodExtractor
implements ThriftExtraction {
    private final short id;
    private final String name;
    private final Method method;
    private final FieldKind fieldKind;
    private final Class<?> type;

    public ThriftMethodExtractor(short fieldId, String fieldName, FieldKind fieldKind, Method method, Type fieldType) {
        this.name = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"name is null");
        this.method = (Method)Preconditions.checkNotNull((Object)method, (Object)"method is null");
        this.fieldKind = (FieldKind)((Object)Preconditions.checkNotNull((Object)((Object)fieldKind), (Object)"fieldKind is null"));
        this.type = TypeToken.of((Type)((Type)Preconditions.checkNotNull((Object)fieldType, (Object)"structType is null"))).getRawType();
        switch (fieldKind) {
            case THRIFT_FIELD: {
                break;
            }
            case THRIFT_UNION_ID: {
                Preconditions.checkArgument((fieldId == Short.MIN_VALUE ? 1 : 0) != 0, (Object)"fieldId must be Short.MIN_VALUE for thrift_union_id");
            }
        }
        this.id = fieldId;
    }

    @Override
    public FieldKind getFieldKind() {
        return this.fieldKind;
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isGeneric() {
        return this.getMethod().getReturnType() != this.getMethod().getGenericReturnType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftMethodExtractor");
        sb.append("{id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", fieldKind=").append((Object)this.fieldKind);
        sb.append(", method=").append(this.method);
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

