/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator;

import com.facebook.swift.generator.TypeRegistry;
import com.facebook.swift.generator.TypeToJavaConverter;
import com.facebook.swift.generator.TypedefRegistry;
import com.facebook.swift.parser.model.BaseType;
import com.facebook.swift.parser.model.Const;
import com.facebook.swift.parser.model.ConstIdentifier;
import com.facebook.swift.parser.model.ConstInteger;
import com.facebook.swift.parser.model.ConstList;
import com.facebook.swift.parser.model.ConstMap;
import com.facebook.swift.parser.model.ConstString;
import com.facebook.swift.parser.model.ConstValue;
import com.facebook.swift.parser.model.IdentifierType;
import com.facebook.swift.parser.model.ListType;
import com.facebook.swift.parser.model.MapType;
import com.facebook.swift.parser.model.SetType;
import com.facebook.swift.parser.model.ThriftType;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConstantRenderer {
    private final TypeToJavaConverter typeConverter;
    private final String defaultNamespace;
    private final TypeRegistry typeRegistry;
    private final TypedefRegistry typedefRegistry;

    public ConstantRenderer(TypeToJavaConverter typeConverter, String defaultNamespace, TypeRegistry typeRegistry, TypedefRegistry typedefRegistry) {
        this.typeConverter = typeConverter;
        this.defaultNamespace = defaultNamespace;
        this.typeRegistry = typeRegistry;
        this.typedefRegistry = typedefRegistry;
    }

    public String render(Const constant) {
        return this.render(constant.getType(), constant.getValue());
    }

    public String render(ThriftType thriftType, ConstValue value) {
        if (thriftType instanceof BaseType) {
            return this.renderBaseConstant((BaseType)thriftType, value);
        }
        if (thriftType instanceof ListType) {
            Preconditions.checkArgument((boolean)(value instanceof ConstList));
            return this.renderListConstant((ListType)thriftType, (ConstList)value);
        }
        if (thriftType instanceof MapType) {
            Preconditions.checkArgument((boolean)(value instanceof ConstMap));
            return this.renderMapType((MapType)thriftType, (ConstMap)value);
        }
        if (thriftType instanceof SetType) {
            Preconditions.checkArgument((boolean)(value instanceof ConstList));
            return this.renderSetConstant((SetType)thriftType, (ConstList)value);
        }
        if (thriftType instanceof IdentifierType) {
            String typeName = ((IdentifierType)thriftType).getName();
            ThriftType resolvedType = this.typedefRegistry.findType(this.defaultNamespace, typeName);
            Preconditions.checkState((resolvedType != null ? 1 : 0) != 0, (Object)String.format("Could not resolve type named '%s'", typeName));
            return this.render(resolvedType, value);
        }
        throw new IllegalStateException("Not yet implemented");
    }

    private String renderIdentifierType(IdentifierType identifierType, ConstIdentifier value) {
        return value.value();
    }

    private String renderMapType(MapType mapType, ConstMap value) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImmutableMap.<");
        sb.append(this.typeConverter.convert(mapType.getKeyType(), false));
        sb.append(", ");
        sb.append(this.typeConverter.convert(mapType.getValueType(), false));
        sb.append(">builder()\n");
        Set entries = value.value().entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getKey() instanceof ConstIdentifier) {
                throw new IllegalStateException("Not yet implemented");
            }
            if (entry.getValue() instanceof ConstIdentifier) {
                throw new IllegalStateException("Not yet implemented");
            }
            sb.append(String.format("    .put(%s, %s)\n", this.render(mapType.getKeyType(), (ConstValue)entry.getKey()), this.render(mapType.getValueType(), (ConstValue)entry.getValue())));
        }
        sb.append("    .build()");
        return sb.toString();
    }

    private String renderListConstant(ListType listType, ConstList value) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImmutableList.<");
        sb.append(this.typeConverter.convert(listType.getElementType(), false));
        sb.append(">builder()\n");
        List elements = value.value();
        for (ConstValue element : elements) {
            if (element instanceof ConstIdentifier) {
                throw new IllegalStateException("Not yet implemented");
            }
            sb.append(String.format("    .add(%s)\n", this.render(listType.getElementType(), element)));
        }
        sb.append("    .build()");
        return sb.toString();
    }

    private String renderSetConstant(SetType setType, ConstList value) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImmutableSet.<");
        sb.append(this.typeConverter.convert(setType.getElementType(), false));
        sb.append(">builder()\n");
        List elements = value.value();
        for (ConstValue element : elements) {
            if (element instanceof ConstIdentifier) {
                throw new IllegalStateException("Not yet implemented");
            }
            sb.append(String.format("    .add(%s)\n", this.render(setType.getElementType(), element)));
        }
        sb.append("    .build()");
        return sb.toString();
    }

    private String renderBaseConstant(BaseType baseType, ConstValue value) {
        switch (baseType.getType()) {
            case BOOL: 
            case BYTE: 
            case I16: 
            case I32: 
            case I64: {
                Preconditions.checkArgument((boolean)(value instanceof ConstInteger));
                return this.renderIntegerConstant(baseType, (ConstInteger)value);
            }
            case STRING: {
                Preconditions.checkArgument((boolean)(value instanceof ConstString));
                return "\"" + value.value() + "\"";
            }
            case DOUBLE: {
                Preconditions.checkArgument((boolean)(value.value() instanceof Number));
                return Double.toString(((Number)value.value()).doubleValue());
            }
        }
        throw new IllegalArgumentException();
    }

    private String renderIntegerConstant(BaseType baseType, ConstInteger value) {
        switch (baseType.getType()) {
            case BOOL: {
                Preconditions.checkArgument((value.value() == 0L || value.value() == 1L ? 1 : 0) != 0, (Object)("Bool constant out of range '" + value.value() + "' (must be 0 or 1)"));
                return Boolean.toString(value.value() != 0L);
            }
            case BYTE: {
                Preconditions.checkArgument((value.value() >= -128L && value.value() <= 127L ? 1 : 0) != 0, (Object)("Byte constant out of range: '" + value.value() + "'"));
                return Byte.toString((byte)value.value().longValue());
            }
            case I16: {
                return Short.toString(Shorts.checkedCast((long)value.value()));
            }
            case I32: {
                return Integer.toString(Ints.checkedCast((long)value.value()));
            }
            case I64: {
                return Long.toString(value.value()) + "L";
            }
        }
        throw new IllegalStateException();
    }
}

