/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator;

import com.facebook.swift.generator.SwiftJavaType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;

public class TypeRegistry
implements Iterable<SwiftJavaType> {
    private final Map<String, SwiftJavaType> registry = Maps.newHashMap();

    public void addAll(TypeRegistry otherRegistry) {
        for (SwiftJavaType type : otherRegistry) {
            this.add(type);
        }
    }

    public void add(SwiftJavaType type) {
        Preconditions.checkState((!this.registry.containsKey(type.getKey()) ? 1 : 0) != 0, (String)"The type %s was already registered!", (Object[])new Object[]{type});
        this.registry.put(type.getKey(), type);
    }

    public SwiftJavaType findType(String thriftNamespace, String name) {
        if (name == null) {
            return null;
        }
        if (name.contains(".")) {
            return this.findType(name);
        }
        return this.findType(thriftNamespace + "." + name);
    }

    public SwiftJavaType findType(String key) {
        if (key == null) {
            return null;
        }
        Preconditions.checkState((boolean)this.registry.containsKey(key), (String)"key %s is not known!", (Object[])new Object[]{key});
        return this.registry.get(key);
    }

    @Override
    public Iterator<SwiftJavaType> iterator() {
        return this.registry.values().iterator();
    }
}

