/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator;

import com.facebook.swift.generator.SwiftJavaType;
import com.facebook.swift.generator.TypeRegistry;
import com.facebook.swift.generator.TypedefRegistry;
import com.facebook.swift.parser.model.BaseType;
import com.facebook.swift.parser.model.IdentifierType;
import com.facebook.swift.parser.model.ListType;
import com.facebook.swift.parser.model.MapType;
import com.facebook.swift.parser.model.SetType;
import com.facebook.swift.parser.model.ThriftType;
import com.facebook.swift.parser.model.VoidType;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class TypeToJavaConverter {
    private final String namespace;
    private final TypeRegistry typeRegistry;
    private final TypedefRegistry typedefRegistry;
    private final List<Converter> converters;
    private final String javaPackage;

    public TypeToJavaConverter(TypeRegistry typeRegistry, TypedefRegistry typedefRegistry, String namespace, String javaPackage) {
        Preconditions.checkNotNull((Object)typeRegistry);
        Preconditions.checkNotNull((Object)typedefRegistry);
        Preconditions.checkNotNull((Object)namespace);
        this.typeRegistry = typeRegistry;
        this.typedefRegistry = typedefRegistry;
        this.namespace = namespace;
        this.javaPackage = javaPackage;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new VoidConverter());
        builder.add((Object)new BaseConverter());
        builder.add((Object)new IdentifierConverter());
        builder.add((Object)new SetConverter());
        builder.add((Object)new ListConverter());
        builder.add((Object)new MapConverter());
        this.converters = builder.build();
    }

    public String convertType(ThriftType thriftType) {
        return this.convert(thriftType, true);
    }

    public String convert(ThriftType thriftType, boolean primitive) {
        for (Converter converter : this.converters) {
            if (!converter.accept(thriftType)) continue;
            return converter.convert(thriftType, primitive);
        }
        throw new IllegalArgumentException("Thrift type %s is unknown!");
    }

    private class MapConverter
    implements Converter {
        private MapConverter() {
        }

        @Override
        public boolean accept(ThriftType type) {
            return type.getClass() == MapType.class;
        }

        @Override
        public String convert(ThriftType type, boolean ignored) {
            MapType mapType = (MapType)MapType.class.cast(type);
            String actualKeyType = TypeToJavaConverter.this.convert(mapType.getKeyType(), false);
            String actualValueType = TypeToJavaConverter.this.convert(mapType.getValueType(), false);
            return String.format("Map<%s, %s>", actualKeyType, actualValueType);
        }
    }

    private class ListConverter
    implements Converter {
        private ListConverter() {
        }

        @Override
        public boolean accept(ThriftType type) {
            return type.getClass() == ListType.class;
        }

        @Override
        public String convert(ThriftType type, boolean ignored) {
            ListType listType = (ListType)ListType.class.cast(type);
            String actualType = TypeToJavaConverter.this.convert(listType.getElementType(), false);
            return "List<" + actualType + ">";
        }
    }

    private class SetConverter
    implements Converter {
        private SetConverter() {
        }

        @Override
        public boolean accept(ThriftType type) {
            return type.getClass() == SetType.class;
        }

        @Override
        public String convert(ThriftType type, boolean ignored) {
            SetType setType = (SetType)SetType.class.cast(type);
            String actualType = TypeToJavaConverter.this.convert(setType.getElementType(), false);
            return "Set<" + actualType + ">";
        }
    }

    private class IdentifierConverter
    implements Converter {
        private IdentifierConverter() {
        }

        @Override
        public boolean accept(ThriftType type) {
            return type.getClass() == IdentifierType.class;
        }

        @Override
        public String convert(ThriftType type, boolean primitive) {
            String name = ((IdentifierType)type).getName();
            ArrayList names = Lists.newArrayList((Iterable)Splitter.on((char)'.').split((CharSequence)name));
            Preconditions.checkState((names.size() > 0 && names.size() < 3 ? 1 : 0) != 0, (Object)"only unqualified and thrift-namespace qualified names are allowed!");
            String thriftName = (String)names.get(0);
            String thriftNamespace = TypeToJavaConverter.this.namespace;
            if (names.size() == 2) {
                thriftName = (String)names.get(1);
                thriftNamespace = (String)names.get(0);
            }
            String thriftTypeName = thriftNamespace + "." + thriftName;
            ThriftType thriftType = TypeToJavaConverter.this.typedefRegistry.findType(thriftTypeName);
            if (thriftType == null) {
                SwiftJavaType javaType = TypeToJavaConverter.this.typeRegistry.findType(thriftTypeName);
                return javaType == null ? null : this.shortenClassName(javaType.getClassName());
            }
            return TypeToJavaConverter.this.convert(thriftType, primitive);
        }

        private String shortenClassName(String className) {
            if (className.startsWith(TypeToJavaConverter.this.javaPackage) && className.lastIndexOf(".") == TypeToJavaConverter.this.javaPackage.length()) {
                className = className.substring(TypeToJavaConverter.this.javaPackage.length() + 1);
            }
            return className;
        }
    }

    private static class BaseConverter
    implements Converter {
        private static final EnumMap<BaseType.Type, String> JAVA_PRIMITIVES_MAP;
        private static final EnumMap<BaseType.Type, String> JAVA_TYPE_MAP;

        private BaseConverter() {
        }

        @Override
        public boolean accept(ThriftType type) {
            return type.getClass() == BaseType.class;
        }

        @Override
        public String convert(ThriftType type, boolean primitive) {
            BaseType.Type baseType = ((BaseType)type).getType();
            return primitive ? JAVA_PRIMITIVES_MAP.get(baseType) : JAVA_TYPE_MAP.get(baseType);
        }

        static {
            EnumMap javaPrimitivesMap = Maps.newEnumMap(BaseType.Type.class);
            javaPrimitivesMap.put(BaseType.Type.BOOL, "boolean");
            javaPrimitivesMap.put(BaseType.Type.BYTE, "byte");
            javaPrimitivesMap.put(BaseType.Type.I16, "short");
            javaPrimitivesMap.put(BaseType.Type.I32, "int");
            javaPrimitivesMap.put(BaseType.Type.I64, "long");
            javaPrimitivesMap.put(BaseType.Type.DOUBLE, "double");
            javaPrimitivesMap.put(BaseType.Type.STRING, "String");
            javaPrimitivesMap.put(BaseType.Type.BINARY, "byte[]");
            JAVA_PRIMITIVES_MAP = javaPrimitivesMap;
            EnumMap javaTypeMap = Maps.newEnumMap(BaseType.Type.class);
            javaTypeMap.put(BaseType.Type.BOOL, "Boolean");
            javaTypeMap.put(BaseType.Type.BYTE, "Byte");
            javaTypeMap.put(BaseType.Type.I16, "Short");
            javaTypeMap.put(BaseType.Type.I32, "Integer");
            javaTypeMap.put(BaseType.Type.I64, "Long");
            javaTypeMap.put(BaseType.Type.DOUBLE, "Double");
            javaTypeMap.put(BaseType.Type.STRING, "String");
            javaTypeMap.put(BaseType.Type.BINARY, "byte[]");
            JAVA_TYPE_MAP = javaTypeMap;
        }
    }

    private static class VoidConverter
    implements Converter {
        private VoidConverter() {
        }

        @Override
        public boolean accept(ThriftType type) {
            return type.getClass() == VoidType.class;
        }

        @Override
        public String convert(ThriftType type, boolean primitive) {
            return primitive ? "void" : "Void";
        }
    }

    private static interface Converter {
        public boolean accept(ThriftType var1);

        public String convert(ThriftType var1, boolean var2);
    }
}

