/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.swift2thrift;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftProtocolType;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.ThriftTypeReference;
import com.facebook.swift.generator.swift2thrift.Swift2ThriftGeneratorConfig;
import com.facebook.swift.generator.swift2thrift.template.FieldRequirednessRenderer;
import com.facebook.swift.generator.swift2thrift.template.ThriftContext;
import com.facebook.swift.generator.swift2thrift.template.ThriftServiceMetadataRenderer;
import com.facebook.swift.generator.swift2thrift.template.ThriftTypeRenderer;
import com.facebook.swift.generator.util.TemplateLoader;
import com.facebook.swift.service.ThriftService;
import com.facebook.swift.service.metadata.ThriftMethodMetadata;
import com.facebook.swift.service.metadata.ThriftServiceMetadata;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import io.airlift.log.Logger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STWriter;

public class Swift2ThriftGenerator {
    private static final Logger LOG = Logger.get(Swift2ThriftGenerator.class);
    private final OutputStreamWriter outputStreamWriter;
    private final boolean verbose;
    private final ThriftCodecManager codecManager = new ThriftCodecManager(new ThriftCodec[0]);
    private final String defaultPackage;
    private final String allowMultiplePackages;
    private ThriftTypeRenderer thriftTypeRenderer;
    private ArrayList<ThriftType> thriftTypes = Lists.newArrayList();
    private ArrayList<ThriftServiceMetadata> thriftServices = Lists.newArrayList();
    private String packageName;
    private Map<Object, String> includeMap = Maps.newHashMap();
    private Set<ThriftType> usedIncludedTypes = Sets.newHashSet();
    private Set<ThriftServiceMetadata> usedIncludedServices = Sets.newHashSet();
    private Set<ThriftType> knownTypes = Sets.newHashSet(builtInKnownTypes);
    private Set<ThriftServiceMetadata> knownServices = Sets.newHashSet();
    private Map<String, String> namespaceMap;
    private boolean recursive;
    private static final Set<ThriftType> builtInKnownTypes = ImmutableSet.of((Object)ThriftType.BOOL, (Object)ThriftType.BYTE, (Object)ThriftType.I16, (Object)ThriftType.I32, (Object)ThriftType.I64, (Object)ThriftType.DOUBLE, (Object[])new ThriftType[]{ThriftType.STRING, ThriftType.BINARY, new ThriftType(ThriftType.BOOL, Boolean.class), new ThriftType(ThriftType.BYTE, Byte.class), new ThriftType(ThriftType.I16, Short.class), new ThriftType(ThriftType.I32, Integer.class), new ThriftType(ThriftType.I64, Long.class), new ThriftType(ThriftType.DOUBLE, Double.class), new ThriftType(ThriftType.STRING, String.class), new ThriftType(ThriftType.BINARY, byte[].class)});

    Swift2ThriftGenerator(Swift2ThriftGeneratorConfig config) throws FileNotFoundException {
        this.verbose = config.isVerbose();
        String defaultPackage = config.getDefaultPackage();
        this.defaultPackage = defaultPackage.isEmpty() ? "" : defaultPackage + ".";
        OutputStream os = config.getOutputFile() != null ? new FileOutputStream(config.getOutputFile()) : System.out;
        this.outputStreamWriter = new OutputStreamWriter(os, Charsets.UTF_8);
        Map<String, String> paramIncludeMap = config.getIncludeMap();
        this.thriftTypeRenderer = new ThriftTypeRenderer((Map<ThriftType, String>)ImmutableMap.of());
        for (Map.Entry<String, String> entry : paramIncludeMap.entrySet()) {
            Object result;
            Class<?> cls = this.load(entry.getKey());
            if (cls == null || (result = this.convertToThrift(cls)) == null) continue;
            this.includeMap.put(result, entry.getValue());
        }
        this.namespaceMap = config.getNamespaceMap();
        this.allowMultiplePackages = config.isAllowMultiplePackages();
        this.recursive = config.isRecursive();
    }

    public void parse(Iterable<String> inputs) throws IOException {
        boolean loadErrors = false;
        if (this.allowMultiplePackages != null) {
            this.packageName = this.allowMultiplePackages;
        }
        for (String className : inputs) {
            Class<?> cls = this.load(className);
            if (cls == null) {
                loadErrors = true;
                continue;
            }
            if (this.packageName == null) {
                this.packageName = cls.getPackage().getName();
            } else if (!this.packageName.equals(cls.getPackage().getName()) && this.allowMultiplePackages == null) {
                throw new IllegalStateException(String.format("Class %s is in package %s, previous classes were in package %s", cls.getName(), cls.getPackage().getName(), this.packageName));
            }
            Object result = this.convertToThrift(cls);
            if (result instanceof ThriftType) {
                this.thriftTypes.add((ThriftType)result);
            } else if (result instanceof ThriftServiceMetadata) {
                this.thriftServices.add((ThriftServiceMetadata)result);
            }
            this.includeMap.remove(result);
        }
        if (loadErrors) {
            LOG.error("Couldn't load some classes");
            return;
        }
        if (this.verify()) {
            this.gen();
        } else {
            LOG.error("Errors found during verification.");
        }
    }

    private String getFullClassName(String className) {
        if (className.indexOf(46) == -1) {
            return this.defaultPackage + className;
        }
        return className;
    }

    private boolean verify() {
        if (this.recursive) {
            int i;
            int len;
            do {
                len = this.thriftTypes.size();
                for (i = 0; i < len; ++i) {
                    this.verifyStruct(this.thriftTypes.get(i), true);
                }
            } while (len != this.thriftTypes.size());
            do {
                len = this.thriftServices.size();
                for (i = 0; i < len; ++i) {
                    this.verifyService(this.thriftServices.get(i), true);
                }
            } while (len != this.thriftServices.size());
            this.recursive = false;
            this.usedIncludedTypes.clear();
            this.usedIncludedServices.clear();
            this.knownTypes = Sets.newHashSet(builtInKnownTypes);
            this.knownServices.clear();
        }
        return this.verifyTypes() & this.verifyServices();
    }

    private boolean verifyTypes() {
        SuccessAndResult<ThriftType> output = this.topologicalSort(this.thriftTypes, new Predicate<ThriftType>(){

            public boolean apply(@Nullable ThriftType t) {
                ThriftProtocolType proto = ((ThriftType)Preconditions.checkNotNull((Object)t)).getProtocolType();
                if (proto == ThriftProtocolType.ENUM || proto == ThriftProtocolType.STRUCT) {
                    return Swift2ThriftGenerator.this.verifyStruct(t, true);
                }
                Preconditions.checkState((boolean)false, (Object)"Top-level non-enum and non-struct?");
                return false;
            }
        });
        if (output.success) {
            this.thriftTypes = output.result;
            return true;
        }
        for (ThriftType t : output.result) {
            this.verifyStruct(t, false);
        }
        return false;
    }

    private boolean verifyServices() {
        SuccessAndResult<ThriftServiceMetadata> output = this.topologicalSort(this.thriftServices, new Predicate<ThriftServiceMetadata>(){

            public boolean apply(@Nullable ThriftServiceMetadata thriftServiceMetadata) {
                return Swift2ThriftGenerator.this.verifyService(thriftServiceMetadata, true);
            }
        });
        if (output.success) {
            this.thriftServices = output.result;
            return true;
        }
        for (ThriftServiceMetadata s : output.result) {
            this.verifyService(s, false);
        }
        return false;
    }

    private <T> SuccessAndResult<T> topologicalSort(ArrayList<T> list, Predicate<T> isKnown) {
        ArrayList remaining = list;
        ArrayList newList = Lists.newArrayList();
        int prevSize = 0;
        while (prevSize != remaining.size()) {
            prevSize = remaining.size();
            ArrayList bad = Lists.newArrayList();
            for (T t : remaining) {
                if (isKnown.apply(t)) {
                    newList.add(t);
                    continue;
                }
                bad.add(t);
            }
            remaining = bad;
        }
        if (prevSize == 0) {
            return new SuccessAndResult(true, newList);
        }
        return new SuccessAndResult<T>(false, remaining);
    }

    private boolean verifyService(ThriftServiceMetadata service, boolean quiet) {
        ThriftServiceMetadata parent;
        boolean ok = true;
        ImmutableList parents = service.getParentServices();
        Preconditions.checkState((parents.size() <= 1 ? 1 : 0) != 0, (String)("service " + service.getName() + " extends multiple services (thrift IDL does not support multiple inheritance for services)"), (Object[])new Object[]{service.getName()});
        ThriftServiceMetadata thriftServiceMetadata = parent = parents.size() == 0 ? null : (ThriftServiceMetadata)parents.get(0);
        if (parent != null && !this.knownServices.contains(parent)) {
            if (this.includeMap.containsKey(parent)) {
                this.usedIncludedServices.add(parent);
            } else {
                ok = false;
                if (!quiet) {
                    LOG.error("Unknown parent service %s in %s", new Object[]{parent.getName(), service.getName()});
                }
            }
        }
        for (Map.Entry method : service.getDeclaredMethods().entrySet()) {
            for (ThriftFieldMetadata f : ((ThriftMethodMetadata)method.getValue()).getParameters()) {
                if (this.verifyField(f.getThriftType())) continue;
                ok = false;
                if (quiet) continue;
                LOG.error("Unknown argument type %s in %s.%s", new Object[]{this.thriftTypeRenderer.toString(f.getThriftType()), service.getName(), method.getKey()});
            }
            for (ThriftType ex : ((ThriftMethodMetadata)method.getValue()).getExceptions().values()) {
                if (this.verifyField(ex)) continue;
                ok = false;
                if (quiet) continue;
                LOG.error("Unknown exception type %s in %s.%s", new Object[]{this.thriftTypeRenderer.toString(ex), service.getName(), method.getKey()});
            }
            if (((ThriftMethodMetadata)method.getValue()).getReturnType().equals((Object)ThriftType.VOID) || this.verifyField(((ThriftMethodMetadata)method.getValue()).getReturnType())) continue;
            ok = false;
            if (quiet) continue;
            LOG.error("Unknown return type %s in %s.%s", new Object[]{this.thriftTypeRenderer.toString(((ThriftMethodMetadata)method.getValue()).getReturnType()), service.getName(), method.getKey()});
        }
        this.knownServices.add(service);
        return ok;
    }

    private boolean verifyElementType(ThriftTypeReference t) {
        if (!this.recursive && t.isRecursive()) {
            return true;
        }
        return this.verifyField(t.get());
    }

    private boolean verifyField(ThriftType t) {
        ThriftProtocolType proto = t.getProtocolType();
        if (proto == ThriftProtocolType.SET || proto == ThriftProtocolType.LIST) {
            return this.verifyElementType(t.getValueTypeReference());
        }
        if (proto == ThriftProtocolType.MAP) {
            return this.verifyElementType(t.getKeyTypeReference()) & this.verifyElementType(t.getValueTypeReference());
        }
        if (this.knownTypes.contains(t)) {
            return true;
        }
        if (this.includeMap.containsKey(t)) {
            this.usedIncludedTypes.add(t);
            return true;
        }
        if (this.recursive) {
            this.thriftTypes.add(t);
            return this.verifyStruct(t, true);
        }
        return false;
    }

    private boolean verifyStruct(ThriftType t, boolean quiet) {
        if (t.getProtocolType() == ThriftProtocolType.ENUM) {
            this.knownTypes.add(t);
            return true;
        }
        ThriftStructMetadata metadata = t.getStructMetadata();
        boolean ok = true;
        this.knownTypes.add(t);
        for (ThriftFieldMetadata fieldMetadata : metadata.getFields(FieldKind.THRIFT_FIELD)) {
            boolean fieldOk;
            if (!this.recursive && fieldMetadata.isTypeReferenceRecursive() || (fieldOk = this.verifyField(fieldMetadata.getThriftType()))) continue;
            ok = false;
            if (quiet) continue;
            LOG.error("Unknown type %s in %s.%s", new Object[]{this.thriftTypeRenderer.toString(fieldMetadata.getThriftType()), metadata.getStructName(), fieldMetadata.getName()});
        }
        if (!ok) {
            this.knownTypes.remove(t);
        }
        return ok;
    }

    private Class<?> load(String className) {
        className = this.getFullClassName(className);
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Couldn't load class %s (%s)", new Object[]{className, e});
            return null;
        }
    }

    private Object convertToThrift(Class<?> cls) {
        Set serviceAnnotations = ReflectionHelper.getEffectiveClassAnnotations(cls, ThriftService.class);
        if (!serviceAnnotations.isEmpty()) {
            ThriftServiceMetadata serviceMetadata = new ThriftServiceMetadata(cls, this.codecManager.getCatalog());
            if (this.verbose) {
                LOG.info("Found thrift service: %s", new Object[]{cls.getSimpleName()});
            }
            return serviceMetadata;
        }
        ThriftType thriftType = this.codecManager.getCatalog().getThriftType(cls);
        if (this.verbose) {
            LOG.info("Found thrift type: %s", new Object[]{this.thriftTypeRenderer.toString(thriftType)});
        }
        return thriftType;
    }

    private void gen() throws IOException {
        String filename;
        ImmutableMap.Builder typenameMap = ImmutableMap.builder();
        ImmutableMap.Builder serviceMap = ImmutableMap.builder();
        ImmutableSet.Builder includes = ImmutableSet.builder();
        for (ThriftType t : this.usedIncludedTypes) {
            filename = this.includeMap.get(t);
            includes.add((Object)filename);
            typenameMap.put((Object)t, (Object)Files.getNameWithoutExtension((String)filename));
        }
        for (ThriftServiceMetadata s : this.usedIncludedServices) {
            filename = this.includeMap.get(s);
            includes.add((Object)filename);
            serviceMap.put((Object)s, (Object)Files.getNameWithoutExtension((String)filename));
        }
        this.thriftTypeRenderer = new ThriftTypeRenderer((Map<ThriftType, String>)typenameMap.build());
        ThriftServiceMetadataRenderer serviceRenderer = new ThriftServiceMetadataRenderer((Map<ThriftServiceMetadata, String>)serviceMap.build());
        TemplateLoader tl = new TemplateLoader((Iterable<String>)ImmutableList.of((Object)"thrift/common.st"), (Map<Class<?>, ? extends AttributeRenderer>)ImmutableMap.of(ThriftType.class, (Object)this.thriftTypeRenderer, ThriftServiceMetadata.class, (Object)serviceRenderer, ThriftField.Requiredness.class, (Object)new FieldRequirednessRenderer()));
        ThriftContext ctx = new ThriftContext(this.packageName, (List<String>)ImmutableList.copyOf((Collection)includes.build()), this.thriftTypes, this.thriftServices, this.namespaceMap);
        ST template = tl.load("thriftfile");
        template.add("context", (Object)ctx);
        template.write((STWriter)new AutoIndentWriter((Writer)this.outputStreamWriter));
        this.outputStreamWriter.flush();
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    private class SuccessAndResult<T> {
        public boolean success;
        public ArrayList<T> result;

        SuccessAndResult(boolean success, ArrayList<T> result) {
            this.success = success;
            this.result = result;
        }
    }
}

