/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.swift2thrift.template;

import com.facebook.swift.codec.metadata.ThriftEnumMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.service.metadata.ThriftServiceMetadata;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;

public class ThriftContext {
    private final String namespace;
    private final List<String> includes;
    private final List<ThriftStructMetadata> thriftStructs = Lists.newArrayList();
    private final List<ThriftEnumMetadata> thriftEnums = Lists.newArrayList();
    private final List<ThriftServiceMetadata> thriftServices;
    private final Map<String, String> customNamespaces;

    public ThriftContext(String namespace, List<String> includes, List<ThriftType> thriftTypes, List<ThriftServiceMetadata> thriftServices, Map<String, String> namespaceMap) {
        this.namespace = namespace;
        this.includes = includes;
        block4: for (ThriftType t : thriftTypes) {
            switch (t.getProtocolType()) {
                case STRUCT: {
                    this.thriftStructs.add(t.getStructMetadata());
                    continue block4;
                }
                case ENUM: {
                    this.thriftEnums.add(t.getEnumMetadata());
                    continue block4;
                }
            }
            throw new IllegalStateException("Unknown protocol type: " + t.getProtocolType());
        }
        this.thriftServices = thriftServices;
        this.customNamespaces = namespaceMap;
    }

    public List<ThriftStructMetadata> getStructs() {
        return this.thriftStructs;
    }

    public List<ThriftEnumMetadata> getEnums() {
        return this.thriftEnums;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getCustomNamespaces() {
        return this.customNamespaces;
    }

    public List<ThriftServiceMetadata> getServices() {
        return this.thriftServices;
    }

    public List<String> getIncludes() {
        return this.includes;
    }
}

