/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.template;

import com.facebook.swift.parser.model.ThriftField;
import com.facebook.swift.parser.model.TypeAnnotation;
import java.util.List;

public class FieldContext {
    private final String name;
    private final List<TypeAnnotation> annotations;
    private final ThriftField.Requiredness requiredness;
    private final boolean isRecursive;
    private final short id;
    private final String javaType;
    private final String javaName;
    private final String javaGetterName;
    private final String javaSetterName;
    private final String javaTestPresenceName;

    FieldContext(String name, List<TypeAnnotation> annotations, ThriftField.Requiredness requiredness, boolean isRecursive, short id, String javaType, String javaName, String javaGetterName, String javaSetterName, String javaTestPresenceName) {
        this.name = name;
        this.annotations = annotations;
        this.requiredness = requiredness;
        this.isRecursive = isRecursive;
        this.id = id;
        this.javaType = javaType;
        this.javaName = javaName;
        this.javaGetterName = javaGetterName;
        this.javaSetterName = javaSetterName;
        this.javaTestPresenceName = javaTestPresenceName;
    }

    public String getName() {
        return this.name;
    }

    public List<TypeAnnotation> getAnnotations() {
        return this.annotations;
    }

    public ThriftField.Requiredness getRequiredness() {
        return this.requiredness;
    }

    public boolean isLegacyId() {
        return this.id < 0;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public short getId() {
        return this.id;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getJavaGetterName() {
        return this.javaGetterName;
    }

    public String getJavaSetterName() {
        return this.javaSetterName;
    }

    public String getJavaTestPresenceName() {
        return this.javaTestPresenceName;
    }

    public boolean isArrayType() {
        return this.getJavaType().endsWith("[]");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.javaGetterName == null ? 0 : this.javaGetterName.hashCode());
        result = 31 * result + (this.javaName == null ? 0 : this.javaName.hashCode());
        result = 31 * result + (this.javaSetterName == null ? 0 : this.javaSetterName.hashCode());
        result = 31 * result + (this.javaTestPresenceName == null ? 0 : this.javaTestPresenceName.hashCode());
        result = 31 * result + (this.javaType == null ? 0 : this.javaType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldContext other = (FieldContext)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.javaGetterName == null ? other.javaGetterName != null : !this.javaGetterName.equals(other.javaGetterName)) {
            return false;
        }
        if (this.javaName == null ? other.javaName != null : !this.javaName.equals(other.javaName)) {
            return false;
        }
        if (this.javaSetterName == null ? other.javaSetterName != null : !this.javaSetterName.equals(other.javaSetterName)) {
            return false;
        }
        if (this.javaTestPresenceName == null ? other.javaTestPresenceName != null : !this.javaTestPresenceName.equals(other.javaTestPresenceName)) {
            return false;
        }
        if (this.javaType == null ? other.javaType != null : !this.javaType.equals(other.javaType)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "FieldContext [name=" + this.name + ", id=" + this.id + ", javaType=" + this.javaType + ", javaName=" + this.javaName + ", javaGetterName=" + this.javaGetterName + ", javaSetterName=" + this.javaSetterName + ", javaTestPresenceName=" + this.javaTestPresenceName + "]";
    }
}

