/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.template;

import com.facebook.swift.generator.template.ExceptionContext;
import com.facebook.swift.generator.template.FieldContext;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class MethodContext {
    private final String name;
    private final boolean oneway;
    private final String javaName;
    private final String javaType;
    private final String boxedJavaType;
    private final boolean allowAsync;
    private final List<FieldContext> parameters = Lists.newArrayList();
    private final List<ExceptionContext> exceptions = Lists.newArrayList();

    MethodContext(@Nullable String name, boolean oneway, String javaName, String javaType, String boxedJavaType) {
        this(name, oneway, javaName, javaType, boxedJavaType, true);
    }

    MethodContext(@Nullable String name, boolean oneway, String javaName, String javaType, String boxedJavaType, boolean allowAsync) {
        this.name = name;
        this.oneway = oneway;
        this.javaName = javaName;
        this.javaType = javaType;
        this.boxedJavaType = boxedJavaType;
        this.allowAsync = allowAsync;
    }

    public void addParameter(FieldContext parameter) {
        this.parameters.add(parameter);
    }

    public void addException(ExceptionContext exception) {
        this.exceptions.add(exception);
    }

    public List<FieldContext> getParameters() {
        return this.parameters;
    }

    public List<ExceptionContext> getExceptions() {
        return this.exceptions;
    }

    public Collection<ExceptionContext> getAnnotatedExceptions() {
        return Collections2.filter(this.exceptions, (Predicate)new Predicate<ExceptionContext>(){

            public boolean apply(ExceptionContext exceptionContext) {
                return exceptionContext.getId() != null;
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getBoxedJavaType() {
        return this.boxedJavaType;
    }

    public boolean getAllowAsync() {
        return this.allowAsync;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exceptions == null ? 0 : this.exceptions.hashCode());
        result = 31 * result + (this.javaName == null ? 0 : this.javaName.hashCode());
        result = 31 * result + (this.javaType == null ? 0 : this.javaType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.oneway ? 1231 : 1237);
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodContext other = (MethodContext)obj;
        if (this.exceptions == null ? other.exceptions != null : !this.exceptions.equals(other.exceptions)) {
            return false;
        }
        if (this.javaName == null ? other.javaName != null : !this.javaName.equals(other.javaName)) {
            return false;
        }
        if (this.javaType == null ? other.javaType != null : !this.javaType.equals(other.javaType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.oneway != other.oneway) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    public String toString() {
        return "MethodContext [name=" + this.name + ", oneway=" + this.oneway + ", javaName=" + this.javaName + ", javaType=" + this.javaType + ", parameters=" + this.parameters + ", exceptions=" + this.exceptions + "]";
    }
}

