/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.template;

import com.facebook.swift.generator.ConstantRenderer;
import com.facebook.swift.generator.SwiftGeneratorConfig;
import com.facebook.swift.generator.SwiftGeneratorTweak;
import com.facebook.swift.generator.SwiftJavaType;
import com.facebook.swift.generator.TypeRegistry;
import com.facebook.swift.generator.TypeToJavaConverter;
import com.facebook.swift.generator.template.ConstantContext;
import com.facebook.swift.generator.template.ConstantsContext;
import com.facebook.swift.generator.template.EnumContext;
import com.facebook.swift.generator.template.EnumFieldContext;
import com.facebook.swift.generator.template.ExceptionContext;
import com.facebook.swift.generator.template.FieldContext;
import com.facebook.swift.generator.template.MethodContext;
import com.facebook.swift.generator.template.ServiceContext;
import com.facebook.swift.generator.template.StructContext;
import com.facebook.swift.generator.util.SwiftInternalStringUtils;
import com.facebook.swift.parser.model.AbstractStruct;
import com.facebook.swift.parser.model.Const;
import com.facebook.swift.parser.model.IntegerEnum;
import com.facebook.swift.parser.model.IntegerEnumField;
import com.facebook.swift.parser.model.Service;
import com.facebook.swift.parser.model.StringEnum;
import com.facebook.swift.parser.model.ThriftField;
import com.facebook.swift.parser.model.ThriftMethod;
import com.google.common.base.Preconditions;
import java.util.HashSet;

public class TemplateContextGenerator {
    private static final MethodContext CLOSE_METHOD_CONTEXT = new MethodContext(null, true, "close", "void", "Void", false);
    private final SwiftGeneratorConfig generatorConfig;
    private final TypeRegistry typeRegistry;
    private final TypeToJavaConverter typeConverter;
    private final String defaultNamespace;
    private final ConstantRenderer constantRenderer;

    public TemplateContextGenerator(SwiftGeneratorConfig generatorConfig, TypeRegistry typeRegistry, TypeToJavaConverter typeConverter, ConstantRenderer constantRenderer, String defaultNamespace) {
        this.generatorConfig = generatorConfig;
        this.typeRegistry = typeRegistry;
        this.defaultNamespace = defaultNamespace;
        this.constantRenderer = constantRenderer;
        this.typeConverter = typeConverter;
    }

    public ServiceContext serviceFromThrift(Service service) {
        boolean addCloseableInterface;
        String name = TemplateContextGenerator.mangleJavaTypeName(service.getName());
        SwiftJavaType javaType = this.typeRegistry.findType(this.defaultNamespace, service.getName());
        SwiftJavaType parentType = this.typeRegistry.findType(this.defaultNamespace, (String)service.getParent().orNull());
        HashSet<String> javaParents = new HashSet<String>();
        if (parentType != null) {
            javaParents.add(parentType.getClassName());
        }
        if (addCloseableInterface = this.generatorConfig.containsTweak(SwiftGeneratorTweak.ADD_CLOSEABLE_INTERFACE)) {
            javaParents.add("Closeable");
        }
        ServiceContext serviceContext = new ServiceContext(name, javaType.getPackage(), javaType.getSimpleName(), javaParents);
        if (addCloseableInterface) {
            serviceContext.addMethod(CLOSE_METHOD_CONTEXT);
        }
        return serviceContext;
    }

    public StructContext structFromThrift(AbstractStruct struct) {
        String thriftTypeName = struct.getName();
        SwiftJavaType javaType = this.typeRegistry.findType(this.defaultNamespace, thriftTypeName);
        return new StructContext(thriftTypeName, javaType.getPackage(), javaType.getSimpleName());
    }

    public MethodContext methodFromThrift(ThriftMethod method) {
        return new MethodContext(method.getName(), method.isOneway(), TemplateContextGenerator.mangleJavaMethodName(method.getName()), this.typeConverter.convertType(method.getReturnType()), this.typeConverter.convert(method.getReturnType(), false));
    }

    public FieldContext fieldFromThrift(ThriftField field) {
        Preconditions.checkState((boolean)field.getIdentifier().isPresent(), (String)"exception %s has no identifier!", (Object[])new Object[]{field.getName()});
        boolean isOptional = field.getRequiredness() == ThriftField.Requiredness.OPTIONAL;
        return new FieldContext(field.getName(), field.getAnnotations(), field.getRequiredness(), field.isRecursive(), ((Long)field.getIdentifier().get()).shortValue(), this.typeConverter.convert(field.getType(), !isOptional), TemplateContextGenerator.mangleJavaMethodName(field.getName()), this.getterName(field), this.setterName(field), this.testPresenceName(field));
    }

    public ConstantsContext constantsFromThrift() {
        String thriftTypeName = "Constants";
        SwiftJavaType javaType = this.typeRegistry.findType(this.defaultNamespace, "Constants");
        return new ConstantsContext("Constants", javaType.getPackage(), javaType.getSimpleName());
    }

    public ConstantContext constantFromThrift(Const constant) {
        return new ConstantContext(constant.getName(), this.typeConverter.convertType(constant.getType()), constant.getName(), this.constantRenderer.render(constant));
    }

    public ExceptionContext exceptionFromThrift(ThriftField field) {
        Preconditions.checkState((boolean)field.getIdentifier().isPresent(), (String)"exception %s has no identifier!", (Object[])new Object[]{field.getName()});
        return new ExceptionContext(this.typeConverter.convertType(field.getType()), ((Long)field.getIdentifier().get()).shortValue());
    }

    public EnumContext enumFromThrift(IntegerEnum integerEnum) {
        String thriftTypeName = integerEnum.getName();
        SwiftJavaType javaType = this.typeRegistry.findType(this.defaultNamespace, thriftTypeName);
        return new EnumContext(javaType.getPackage(), javaType.getSimpleName());
    }

    public EnumContext enumFromThrift(StringEnum stringEnum) {
        String thriftTypeName = stringEnum.getName();
        SwiftJavaType javaType = this.typeRegistry.findType(this.defaultNamespace, thriftTypeName);
        return new EnumContext(javaType.getPackage(), javaType.getSimpleName());
    }

    public EnumFieldContext fieldFromThrift(IntegerEnumField field) {
        return new EnumFieldContext(TemplateContextGenerator.mangleJavaConstantName(field.getName()), field.getValue());
    }

    public EnumFieldContext fieldFromThrift(String value) {
        return new EnumFieldContext(TemplateContextGenerator.mangleJavaConstantName(value), null);
    }

    public static final String mangleJavaMethodName(String src) {
        return TemplateContextGenerator.mangleJavaName(src, false);
    }

    public static final String mangleJavaTypeName(String src) {
        return TemplateContextGenerator.mangleJavaName(src, true);
    }

    private static final String mangleJavaName(String src, boolean capitalize) {
        Preconditions.checkArgument((!SwiftInternalStringUtils.isBlank(src) ? 1 : 0) != 0, (Object)"input name must not be blank!");
        StringBuilder sb = new StringBuilder();
        boolean upCase = capitalize;
        boolean downCase = !capitalize && !TemplateContextGenerator.nameStartsWithAcronym(src);
        for (int i = 0; i < src.length(); ++i) {
            if (src.charAt(i) == '_') {
                upCase = true;
                continue;
            }
            char ch = src.charAt(i);
            ch = downCase ? Character.toLowerCase(src.charAt(i)) : ch;
            ch = upCase ? Character.toUpperCase(src.charAt(i)) : ch;
            sb.append(ch);
            upCase = false;
            downCase = false;
        }
        return sb.toString();
    }

    public static final String mangleJavaConstantName(String src) {
        StringBuilder sb = new StringBuilder();
        if (!SwiftInternalStringUtils.isBlank(src)) {
            boolean lowerCase = false;
            for (int i = 0; i < src.length(); ++i) {
                if (Character.isUpperCase(src.charAt(i))) {
                    if (lowerCase) {
                        sb.append('_');
                    }
                    sb.append(Character.toUpperCase(src.charAt(i)));
                    lowerCase = false;
                    continue;
                }
                if (Character.isLowerCase(src.charAt(i))) {
                    sb.append(Character.toUpperCase(src.charAt(i)));
                    lowerCase = true;
                    continue;
                }
                sb.append(src.charAt(i));
            }
        }
        return sb.toString();
    }

    private static boolean nameStartsWithAcronym(String name) {
        if (name.length() <= 1) {
            return false;
        }
        return Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1));
    }

    private String getterName(ThriftField field) {
        String type = this.typeConverter.convertType(field.getType());
        return ("boolean".equals(type) ? "is" : "get") + TemplateContextGenerator.mangleJavaTypeName(field.getName());
    }

    private String setterName(ThriftField field) {
        return "set" + TemplateContextGenerator.mangleJavaTypeName(field.getName());
    }

    private String testPresenceName(ThriftField field) {
        return "isSet" + TemplateContextGenerator.mangleJavaTypeName(field.getName());
    }
}

