/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.visitors;

import com.facebook.swift.generator.SwiftDocumentContext;
import com.facebook.swift.generator.SwiftGeneratorConfig;
import com.facebook.swift.generator.SwiftGeneratorTweak;
import com.facebook.swift.generator.template.JavaContext;
import com.facebook.swift.generator.template.TemplateContextGenerator;
import com.facebook.swift.generator.util.TemplateLoader;
import com.facebook.swift.parser.visitor.DocumentVisitor;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STWriter;

public abstract class AbstractTemplateVisitor
implements DocumentVisitor {
    private final File outputFolder;
    private final TemplateLoader templateLoader;
    protected final TemplateContextGenerator contextGenerator;
    protected final SwiftGeneratorConfig config;

    protected AbstractTemplateVisitor(TemplateLoader templateLoader, SwiftDocumentContext context, SwiftGeneratorConfig config, File outputFolder) {
        this.outputFolder = outputFolder;
        this.templateLoader = templateLoader;
        this.contextGenerator = context.getTemplateContextGenerator();
        this.config = config;
    }

    protected void render(JavaContext context, String templateName) throws IOException {
        ST template = this.templateLoader.load(templateName);
        Preconditions.checkState((template != null ? 1 : 0) != 0, (String)"No template for '%s' found!", (Object[])new Object[]{templateName});
        template.add("context", (Object)context);
        HashMap<String, Boolean> tweakMap = new HashMap<String, Boolean>();
        for (SwiftGeneratorTweak tweak : SwiftGeneratorTweak.values()) {
            tweakMap.put(tweak.name(), this.config.containsTweak(tweak));
        }
        template.add("tweaks", tweakMap);
        Iterable packages = Splitter.on((char)'.').split((CharSequence)context.getJavaPackage());
        File folder = this.outputFolder;
        for (String pkg : packages) {
            folder = new File(folder, pkg);
            folder.mkdir();
        }
        File file = new File(folder, context.getJavaName() + ".java");
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
            template.write((STWriter)new AutoIndentWriter((Writer)osw));
            osw.flush();
        }
    }

    public void finish() throws IOException {
    }
}

