/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.visitors;

import com.facebook.swift.generator.SwiftDocumentContext;
import com.facebook.swift.generator.SwiftGeneratorConfig;
import com.facebook.swift.generator.SwiftGeneratorTweak;
import com.facebook.swift.generator.template.ExceptionContext;
import com.facebook.swift.generator.template.MethodContext;
import com.facebook.swift.generator.template.ServiceContext;
import com.facebook.swift.generator.util.TemplateLoader;
import com.facebook.swift.generator.visitors.AbstractTemplateVisitor;
import com.facebook.swift.parser.model.Service;
import com.facebook.swift.parser.model.ThriftField;
import com.facebook.swift.parser.model.ThriftMethod;
import com.facebook.swift.parser.visitor.Visitable;
import java.io.File;
import java.io.IOException;

public class ServiceVisitor
extends AbstractTemplateVisitor {
    private static final ExceptionContext THRIFT_EXCEPTION_CONTEXT = ExceptionContext.forType("org.apache.thrift.TException");

    public ServiceVisitor(TemplateLoader templateLoader, SwiftDocumentContext context, SwiftGeneratorConfig config, File outputFolder) {
        super(templateLoader, context, config, outputFolder);
    }

    public boolean accept(Visitable visitable) {
        return visitable.getClass() == Service.class;
    }

    public void visit(Visitable visitable) throws IOException {
        Service service = (Service)Service.class.cast(visitable);
        ServiceContext serviceContext = this.contextGenerator.serviceFromThrift(service);
        for (ThriftMethod method : service.getMethods()) {
            MethodContext methodContext = this.contextGenerator.methodFromThrift(method);
            serviceContext.addMethod(methodContext);
            for (ThriftField field : method.getArguments()) {
                methodContext.addParameter(this.contextGenerator.fieldFromThrift(field));
            }
            for (ThriftField field : method.getThrowsFields()) {
                methodContext.addException(this.contextGenerator.exceptionFromThrift(field));
            }
            if (!this.config.containsTweak(SwiftGeneratorTweak.ADD_THRIFT_EXCEPTION)) continue;
            methodContext.addException(THRIFT_EXCEPTION_CONTEXT);
        }
        this.render(serviceContext, "service");
    }
}

