/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser.model;

import com.facebook.swift.parser.model.ConstValue;
import com.facebook.swift.parser.model.ThriftType;
import com.facebook.swift.parser.model.TypeAnnotation;
import com.facebook.swift.parser.visitor.DocumentVisitor;
import com.facebook.swift.parser.visitor.Visitable;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;

public class ThriftField
implements Visitable {
    private final String name;
    private final ThriftType type;
    private final Optional<Long> identifier;
    private final Requiredness requiredness;
    private final Optional<ConstValue> value;
    private final List<TypeAnnotation> annotations;
    private final boolean isRecursiveReference;

    public ThriftField(String name, ThriftType type, Long identifier, Requiredness requiredness, ConstValue value, List<TypeAnnotation> annotations) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.type = (ThriftType)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.identifier = Optional.fromNullable((Object)identifier);
        this.requiredness = (Requiredness)((Object)Preconditions.checkNotNull((Object)((Object)requiredness), (Object)"requiredness"));
        this.value = Optional.fromNullable((Object)value);
        this.annotations = (List)Preconditions.checkNotNull(annotations, (Object)"annotations");
        this.isRecursiveReference = Iterables.removeIf(annotations, annotation -> annotation.getName().equals("swift.recursive_reference") && annotation.getValue().equals("true"));
    }

    public String getName() {
        return this.name;
    }

    public ThriftType getType() {
        return this.type;
    }

    public Optional<Long> getIdentifier() {
        return this.identifier;
    }

    public Requiredness getRequiredness() {
        return this.requiredness;
    }

    public boolean isRecursive() {
        return this.isRecursiveReference;
    }

    public Optional<ConstValue> getValue() {
        return this.value;
    }

    public List<TypeAnnotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("identifier", this.identifier).add("requiredness", (Object)this.requiredness).add("value", this.value).add("annotations", this.annotations).toString();
    }

    @Override
    public void visit(DocumentVisitor visitor) throws IOException {
        visitor.visit(this);
    }

    public static enum Requiredness {
        REQUIRED,
        OPTIONAL,
        NONE;

    }
}

