/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.client.RequestChannel;
import com.facebook.nifty.core.RequestContext;
import com.facebook.nifty.core.RequestContexts;
import com.facebook.nifty.core.TChannelBufferInputTransport;
import com.facebook.nifty.core.TChannelBufferOutputTransport;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.service.ClientContextChain;
import com.facebook.swift.service.SyncClientHelpers;
import com.facebook.swift.service.metadata.ThriftMethodMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.jboss.netty.buffer.ChannelBuffer;
import org.weakref.jmx.Managed;

@ThreadSafe
public class ThriftMethodHandler {
    private final String name;
    private final String qualifiedName;
    private final List<ParameterHandler> parameterCodecs;
    private final ThriftCodec<Object> successCodec;
    private final Map<Short, ThriftCodec<Object>> exceptionCodecs;
    private final boolean oneway;
    private final boolean invokeAsynchronously;

    public ThriftMethodHandler(ThriftMethodMetadata methodMetadata, ThriftCodecManager codecManager) {
        this.name = methodMetadata.getName();
        this.qualifiedName = methodMetadata.getQualifiedName();
        this.invokeAsynchronously = methodMetadata.isAsync();
        this.oneway = methodMetadata.getOneway();
        Object[] parameters = new ParameterHandler[methodMetadata.getParameters().size()];
        for (ThriftFieldMetadata fieldMetadata : methodMetadata.getParameters()) {
            ThriftParameterInjection parameter = (ThriftParameterInjection)fieldMetadata.getInjections().get(0);
            ParameterHandler handler = new ParameterHandler(fieldMetadata.getId(), fieldMetadata.getName(), codecManager.getCodec(fieldMetadata.getThriftType()));
            parameters[parameter.getParameterIndex()] = handler;
        }
        this.parameterCodecs = ImmutableList.copyOf((Object[])parameters);
        ImmutableMap.Builder exceptions = ImmutableMap.builder();
        for (Map.Entry<Short, ThriftType> entry : methodMetadata.getExceptions().entrySet()) {
            exceptions.put((Object)entry.getKey(), (Object)codecManager.getCodec(entry.getValue()));
        }
        this.exceptionCodecs = exceptions.build();
        this.successCodec = codecManager.getCodec(methodMetadata.getReturnType());
    }

    @Managed
    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(RequestChannel channel, TChannelBufferInputTransport inputTransport, TChannelBufferOutputTransport outputTransport, TProtocol inputProtocol, TProtocol outputProtocol, int sequenceId, ClientContextChain contextChain, Object ... args) throws Exception {
        if (this.invokeAsynchronously) {
            return this.asynchronousInvoke(channel, inputTransport, outputTransport, inputProtocol, outputProtocol, sequenceId, contextChain, args);
        }
        try {
            Object object = this.synchronousInvoke(channel, inputTransport, outputTransport, inputProtocol, outputProtocol, sequenceId, contextChain, args);
            return object;
        }
        finally {
            contextChain.done();
        }
    }

    private Object synchronousInvoke(RequestChannel channel, TChannelBufferInputTransport inputTransport, TChannelBufferOutputTransport outputTransport, TProtocol inputProtocol, TProtocol outputProtocol, int sequenceId, ClientContextChain contextChain, Object[] args) throws Exception {
        Object results = null;
        contextChain.preWrite(args);
        outputTransport.resetOutputBuffer();
        this.writeArguments(outputProtocol, sequenceId, args);
        ChannelBuffer requestBuffer = outputTransport.getOutputBuffer();
        contextChain.postWrite(args);
        if (!this.oneway) {
            ChannelBuffer responseBuffer;
            try {
                responseBuffer = SyncClientHelpers.sendSynchronousTwoWayMessage(channel, requestBuffer);
            }
            catch (Exception e) {
                contextChain.preReadException(e);
                throw e;
            }
            contextChain.preRead();
            try {
                inputTransport.setInputBuffer(responseBuffer);
                this.waitForResponse(inputProtocol, sequenceId);
                results = this.readResponse(inputProtocol);
                contextChain.postRead(results);
            }
            catch (Exception e) {
                contextChain.postReadException(e);
                throw e;
            }
        }
        SyncClientHelpers.sendSynchronousOneWayMessage(channel, requestBuffer);
        return results;
    }

    public ListenableFuture<Object> asynchronousInvoke(RequestChannel channel, final TChannelBufferInputTransport inputTransport, TChannelBufferOutputTransport outputTransport, final TProtocol inputProtocol, TProtocol outputProtocol, final int sequenceId, final ClientContextChain contextChain, Object[] args) throws Exception {
        final AsyncMethodCallFuture future = AsyncMethodCallFuture.create(contextChain);
        final RequestContext requestContext = RequestContexts.getCurrentContext();
        contextChain.preWrite(args);
        outputTransport.resetOutputBuffer();
        this.writeArguments(outputProtocol, sequenceId, args);
        ChannelBuffer requestBuffer = outputTransport.getOutputBuffer().copy();
        contextChain.postWrite(args);
        channel.sendAsynchronousRequest(requestBuffer, false, new RequestChannel.Listener(){

            public void onRequestSent() {
                if (ThriftMethodHandler.this.oneway) {
                    try {
                        future.set(null);
                    }
                    catch (Exception e) {
                        future.setException(e);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponseReceived(ChannelBuffer message) {
                RequestContext oldRequestContext = RequestContexts.getCurrentContext();
                RequestContexts.setCurrentContext((RequestContext)requestContext);
                try {
                    contextChain.preRead();
                    inputTransport.setInputBuffer(message);
                    ThriftMethodHandler.this.waitForResponse(inputProtocol, sequenceId);
                    Object results = ThriftMethodHandler.this.readResponse(inputProtocol);
                    contextChain.postRead(results);
                    future.set(results);
                }
                catch (Exception e) {
                    contextChain.postReadException(e);
                    future.setException(e);
                }
                finally {
                    RequestContexts.setCurrentContext((RequestContext)oldRequestContext);
                }
            }

            public void onChannelError(TException e) {
                RequestContext oldRequestContext = RequestContexts.getCurrentContext();
                RequestContexts.setCurrentContext((RequestContext)requestContext);
                try {
                    contextChain.preReadException(e);
                    future.setException(e);
                }
                finally {
                    RequestContexts.setCurrentContext((RequestContext)oldRequestContext);
                }
            }
        });
        return future;
    }

    private Object readResponse(TProtocol in) throws Exception {
        TProtocolReader reader = new TProtocolReader(in);
        reader.readStructBegin();
        Object results = null;
        Exception exception = null;
        while (reader.nextField()) {
            if (reader.getFieldId() == 0) {
                results = reader.readField(this.successCodec);
                continue;
            }
            ThriftCodec<Object> exceptionCodec = this.exceptionCodecs.get(reader.getFieldId());
            if (exceptionCodec != null) {
                exception = (Exception)reader.readField(exceptionCodec);
                continue;
            }
            reader.skipFieldData();
        }
        reader.readStructEnd();
        in.readMessageEnd();
        if (exception != null) {
            throw exception;
        }
        if (this.successCodec.getType() == ThriftType.VOID) {
            return null;
        }
        if (results == null) {
            throw new TApplicationException(5, this.name + " failed: unknown result");
        }
        return results;
    }

    private void writeArguments(TProtocol out, int sequenceId, Object[] args) throws Exception {
        out.writeMessageBegin(new TMessage(this.name, this.oneway ? (byte)4 : 1, sequenceId));
        TProtocolWriter writer = new TProtocolWriter(out);
        writer.writeStructBegin(this.name + "_args");
        for (int i = 0; i < args.length; ++i) {
            Object value = args[i];
            ParameterHandler parameter = this.parameterCodecs.get(i);
            writer.writeField(parameter.getName(), parameter.getId(), parameter.getCodec(), value);
        }
        writer.writeStructEnd();
        out.writeMessageEnd();
        out.getTransport().flush();
    }

    private void waitForResponse(TProtocol in, int sequenceId) throws TException {
        TMessage message = in.readMessageBegin();
        if (message.type == 3) {
            TApplicationException exception = TApplicationException.read((TProtocol)in);
            in.readMessageEnd();
            throw exception;
        }
        if (message.type != 2) {
            throw new TApplicationException(2, "Received invalid message type " + message.type + " from server");
        }
        if (!message.name.equals(this.name)) {
            throw new TApplicationException(3, "Wrong method name in reply: expected " + this.name + " but received " + message.name);
        }
        if (message.seqid != sequenceId) {
            throw new TApplicationException(4, this.name + " failed: out of sequence response");
        }
    }

    private static final class AsyncMethodCallFuture<T>
    extends AbstractFuture<T> {
        private final ClientContextChain contextChain;

        public static <T> AsyncMethodCallFuture<T> create(ClientContextChain contextChain) {
            return new AsyncMethodCallFuture<T>(contextChain);
        }

        private AsyncMethodCallFuture(ClientContextChain contextChain) {
            this.contextChain = contextChain;
        }

        public boolean set(@Nullable T value) {
            this.contextChain.done();
            return super.set(value);
        }

        public boolean setException(Throwable throwable) {
            this.contextChain.done();
            return super.setException(throwable);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }
    }

    private static final class ParameterHandler {
        private final short id;
        private final String name;
        private final ThriftCodec<Object> codec;

        private ParameterHandler(short id, String name, ThriftCodec<Object> codec) {
            this.id = id;
            this.name = name;
            this.codec = codec;
        }

        public short getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public ThriftCodec<Object> getCodec() {
            return this.codec;
        }
    }
}

