/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.core.RequestContext;
import com.facebook.nifty.core.RequestContexts;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.service.ContextChain;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.facebook.swift.service.metadata.ThriftMethodMetadata;
import com.google.common.base.Defaults;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.weakref.jmx.Managed;

@ThreadSafe
public class ThriftMethodProcessor {
    private final String name;
    private final String serviceName;
    private final String qualifiedName;
    private final Object service;
    private final Method method;
    private final String resultStructName;
    private final boolean oneway;
    private final ImmutableList<ThriftFieldMetadata> parameters;
    private final Map<Short, ThriftCodec<?>> parameterCodecs;
    private final Map<Short, Short> thriftParameterIdToJavaArgumentListPositionMap;
    private final ThriftCodec<Object> successCodec;
    private final Map<Class<?>, ExceptionProcessor> exceptionCodecs;

    public ThriftMethodProcessor(Object service, String serviceName, ThriftMethodMetadata methodMetadata, ThriftCodecManager codecManager) {
        this.service = service;
        this.serviceName = serviceName;
        this.name = methodMetadata.getName();
        this.qualifiedName = serviceName + "." + this.name;
        this.resultStructName = this.name + "_result";
        this.method = methodMetadata.getMethod();
        this.oneway = methodMetadata.getOneway();
        this.parameters = ImmutableList.copyOf(methodMetadata.getParameters());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ThriftFieldMetadata fieldMetadata : methodMetadata.getParameters()) {
            builder.put((Object)fieldMetadata.getId(), (Object)codecManager.getCodec(fieldMetadata.getThriftType()));
        }
        this.parameterCodecs = builder.build();
        ImmutableMap.Builder parameterOrderingBuilder = ImmutableMap.builder();
        short javaArgumentPosition = 0;
        for (ThriftFieldMetadata fieldMetadata : methodMetadata.getParameters()) {
            short s = javaArgumentPosition;
            javaArgumentPosition = (short)(javaArgumentPosition + 1);
            parameterOrderingBuilder.put((Object)fieldMetadata.getId(), (Object)s);
        }
        this.thriftParameterIdToJavaArgumentListPositionMap = parameterOrderingBuilder.build();
        ImmutableMap.Builder exceptions = ImmutableMap.builder();
        for (Map.Entry<Short, ThriftType> entry : methodMetadata.getExceptions().entrySet()) {
            Class type = TypeToken.of((Type)entry.getValue().getJavaType()).getRawType();
            ExceptionProcessor processor = new ExceptionProcessor(entry.getKey(), codecManager.getCodec(entry.getValue()));
            exceptions.put((Object)type, (Object)processor);
        }
        this.exceptionCodecs = exceptions.build();
        this.successCodec = codecManager.getCodec(methodMetadata.getReturnType());
    }

    @Managed
    public String getName() {
        return this.name;
    }

    public Class<?> getServiceClass() {
        return this.service.getClass();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public ListenableFuture<Boolean> process(TProtocol in, final TProtocol out, final int sequenceId, final ContextChain contextChain) throws Exception {
        contextChain.preRead();
        Object[] args = this.readArguments(in);
        contextChain.postRead(args);
        final RequestContext requestContext = RequestContexts.getCurrentContext();
        in.readMessageEnd();
        ListenableFuture<?> invokeFuture = this.invokeMethod(args);
        final SettableFuture resultFuture = SettableFuture.create();
        Futures.addCallback(invokeFuture, (FutureCallback)new FutureCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(Object result) {
                if (ThriftMethodProcessor.this.oneway) {
                    resultFuture.set((Object)true);
                } else {
                    RequestContext oldRequestContext = RequestContexts.getCurrentContext();
                    RequestContexts.setCurrentContext((RequestContext)requestContext);
                    try {
                        contextChain.preWrite(result);
                        ThriftMethodProcessor.this.writeResponse(out, sequenceId, (byte)2, "success", (short)0, ThriftMethodProcessor.this.successCodec, result);
                        contextChain.postWrite(result);
                        resultFuture.set((Object)true);
                    }
                    catch (Exception e) {
                        resultFuture.setException((Throwable)e);
                    }
                    finally {
                        RequestContexts.setCurrentContext((RequestContext)oldRequestContext);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Throwable t) {
                RequestContext oldRequestContext = RequestContexts.getCurrentContext();
                RequestContexts.setCurrentContext((RequestContext)requestContext);
                try {
                    contextChain.preWriteException(t);
                    if (!ThriftMethodProcessor.this.oneway) {
                        ExceptionProcessor exceptionCodec = (ExceptionProcessor)ThriftMethodProcessor.this.exceptionCodecs.get(t.getClass());
                        if (exceptionCodec == null) {
                            for (Map.Entry entry : ThriftMethodProcessor.this.exceptionCodecs.entrySet()) {
                                if (!((Class)entry.getKey()).isAssignableFrom(t.getClass())) continue;
                                exceptionCodec = (ExceptionProcessor)entry.getValue();
                                break;
                            }
                        }
                        if (exceptionCodec != null) {
                            contextChain.declaredUserException(t, exceptionCodec.getCodec());
                            ThriftMethodProcessor.this.writeResponse(out, sequenceId, (byte)2, "exception", exceptionCodec.getId(), exceptionCodec.getCodec(), t);
                            contextChain.postWriteException(t);
                        } else {
                            contextChain.undeclaredUserException(t);
                            TApplicationException applicationException = ThriftServiceProcessor.createAndWriteApplicationException(out, requestContext, ThriftMethodProcessor.this.method.getName(), sequenceId, 6, "Internal error processing " + ThriftMethodProcessor.this.method.getName() + ": " + t.getMessage(), t);
                            contextChain.postWriteException((Throwable)applicationException);
                        }
                    }
                    resultFuture.set((Object)true);
                }
                catch (Exception e) {
                    resultFuture.setException((Throwable)e);
                }
                finally {
                    RequestContexts.setCurrentContext((RequestContext)oldRequestContext);
                }
            }
        });
        return resultFuture;
    }

    private ListenableFuture<?> invokeMethod(Object[] args) {
        try {
            Object response = this.method.invoke(this.service, args);
            if (response instanceof ListenableFuture) {
                return (ListenableFuture)response;
            }
            return Futures.immediateFuture((Object)response);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                return Futures.immediateFailedFuture((Throwable)cause);
            }
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private Object[] readArguments(TProtocol in) throws Exception {
        try {
            int numArgs = this.method.getParameterTypes().length;
            Object[] args = new Object[numArgs];
            TProtocolReader reader = new TProtocolReader(in);
            reader.readStructBegin();
            while (reader.nextField()) {
                short fieldId = reader.getFieldId();
                ThriftCodec<?> codec = this.parameterCodecs.get(fieldId);
                if (codec == null) {
                    reader.skipFieldData();
                    continue;
                }
                args[this.thriftParameterIdToJavaArgumentListPositionMap.get((Object)Short.valueOf((short)fieldId)).shortValue()] = reader.readField(codec);
            }
            reader.readStructEnd();
            int argumentPosition = 0;
            for (ThriftFieldMetadata argument : this.parameters) {
                Type argumentType;
                if (args[argumentPosition] == null && (argumentType = argument.getThriftType().getJavaType()) instanceof Class) {
                    Class argumentClass = (Class)argumentType;
                    argumentClass = Primitives.unwrap((Class)argumentClass);
                    args[argumentPosition] = Defaults.defaultValue((Class)argumentClass);
                }
                ++argumentPosition;
            }
            return args;
        }
        catch (TProtocolException e) {
            throw new TApplicationException(7, e.getMessage());
        }
    }

    private <T> void writeResponse(TProtocol out, int sequenceId, byte responseType, String responseFieldName, short responseFieldId, ThriftCodec<T> responseCodec, T result) throws Exception {
        out.writeMessageBegin(new TMessage(this.name, responseType, sequenceId));
        TProtocolWriter writer = new TProtocolWriter(out);
        writer.writeStructBegin(this.resultStructName);
        writer.writeField(responseFieldName, responseFieldId, responseCodec, result);
        writer.writeStructEnd();
        out.writeMessageEnd();
        out.getTransport().flush();
    }

    private static final class ExceptionProcessor {
        private final short id;
        private final ThriftCodec<Object> codec;

        private ExceptionProcessor(short id, ThriftCodec<?> coded) {
            this.id = id;
            this.codec = coded;
        }

        public short getId() {
            return this.id;
        }

        public ThriftCodec<Object> getCodec() {
            return this.codec;
        }
    }
}

