/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.stats.TimeStat;
import io.airlift.units.Duration;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ThriftMethodStats {
    private final TimeStat success = new TimeStat();
    private final TimeStat read = new TimeStat();
    private final TimeStat invoke = new TimeStat();
    private final TimeStat write = new TimeStat();
    private final TimeStat error = new TimeStat();
    private final DistributionStat readSize = new DistributionStat();
    private final DistributionStat writeSize = new DistributionStat();
    private final CounterStat readSizeTotal = new CounterStat();
    private final CounterStat writeSizeTotal = new CounterStat();

    @Managed
    @Nested
    public TimeStat getRead() {
        return this.read;
    }

    @Managed
    @Nested
    public TimeStat getInvoke() {
        return this.invoke;
    }

    @Managed
    @Nested
    public TimeStat getWrite() {
        return this.write;
    }

    @Managed
    @Nested
    public TimeStat getSuccess() {
        return this.success;
    }

    @Managed
    @Nested
    public TimeStat getError() {
        return this.error;
    }

    @Managed
    @Nested
    public DistributionStat getReadSize() {
        return this.readSize;
    }

    @Managed
    @Nested
    public DistributionStat getWriteSize() {
        return this.writeSize;
    }

    @Managed
    @Nested
    public CounterStat getReadSizeTotal() {
        return this.readSizeTotal;
    }

    @Managed
    @Nested
    public CounterStat getWriteSizeTotal() {
        return this.writeSizeTotal;
    }

    public void addReadTime(Duration duration) {
        this.read.add(duration);
    }

    public void addInvokeTime(Duration duration) {
        this.invoke.add(duration);
    }

    public void addWriteTime(Duration duration) {
        this.write.add(duration);
    }

    public void addSuccessTime(Duration duration) {
        this.success.add(duration);
    }

    public void addErrorTime(Duration duration) {
        this.error.add(duration);
    }

    public void addReadByteCount(int readByteCount) {
        this.readSizeTotal.update((long)readByteCount);
        this.readSize.add((long)readByteCount);
    }

    public void addWriteByteCount(int writeByteCount) {
        this.writeSizeTotal.update((long)writeByteCount);
        this.writeSize.add((long)writeByteCount);
    }
}

