/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.executor;

import cn.binarywang.wx.miniapp.bean.vod.WxMaVodUploadPartResult;
import cn.binarywang.wx.miniapp.executor.VodUploadPartRequestExecutor;
import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpVodUploadPartRequestExecutor
extends VodUploadPartRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    public OkHttpVodUploadPartRequestExecutor(RequestHttp requestHttp, String uploadId, Integer partNumber, Integer resourceType) {
        super(requestHttp, uploadId, partNumber, resourceType);
    }

    public WxMaVodUploadPartResult execute(String uri, File file, WxType wxType) throws WxErrorException, IOException {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MediaType.parse((String)"multipart/form-data")).addFormDataPart("data", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
        bodyBuilder.addFormDataPart("upload_id", this.uploadId).addFormDataPart("part_number", String.valueOf(this.partNumber)).addFormDataPart("resource_type", String.valueOf(this.resourceType));
        Request request = new Request.Builder().url(uri).post((RequestBody)bodyBuilder.build()).build();
        Response response = ((OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson((String)responseContent, (WxType)wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMaVodUploadPartResult.fromJson(responseContent);
    }
}

