/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import java.util.function.Function;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.env.Environment;

public final class LazyStringEncryptor
implements StringEncryptor {
    private final Function<Environment, StringEncryptor> supplier;
    private Environment environment;

    public LazyStringEncryptor(Function<Environment, StringEncryptor> encryptorFactory, Environment environment) {
        this.supplier = new SingletonFunction<Environment, StringEncryptor>(encryptorFactory);
        this.environment = environment;
    }

    public String encrypt(String message) {
        return this.supplier.apply(this.environment).encrypt(message);
    }

    public String decrypt(String encryptedMessage) {
        return this.supplier.apply(this.environment).decrypt(encryptedMessage);
    }

    private static final class SingletonFunction<T, R>
    implements Function<T, R> {
        private boolean initialized = false;
        private volatile Function<T, R> instanceFunction = t -> {
            Function function = original;
            synchronized (function) {
                if (!this.initialized) {
                    Object singletonInstance = original.apply(t);
                    this.instanceFunction = t1 -> singletonInstance;
                    this.initialized = true;
                }
                return this.instanceFunction.apply(t);
            }
        };

        private SingletonFunction(Function<T, R> original) {
        }

        @Override
        public R apply(T t) {
            return this.instanceFunction.apply(t);
        }
    }
}

