/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.IObsCredentialsProvider;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.ISecurityKey;

public class EnvironmentVariableObsCredentialsProvider
implements IObsCredentialsProvider {
    private BasicSecurityKey securityKey;

    public EnvironmentVariableObsCredentialsProvider() {
        String accessKey = EnvironmentVariableObsCredentialsProvider.stringTrim(System.getenv("OBS_ACCESS_KEY_ID"));
        String secretKey = EnvironmentVariableObsCredentialsProvider.stringTrim(System.getenv("OBS_SECRET_ACCESS_KEY"));
        String securityToken = EnvironmentVariableObsCredentialsProvider.stringTrim(System.getenv("OBS_SECURITY_TOKEN"));
        ServiceUtils.asserParameterNotNull(accessKey, "access key should not be null or empty.");
        ServiceUtils.asserParameterNotNull(secretKey, "secret key should not be null or empty.");
        this.securityKey = new BasicSecurityKey(accessKey, secretKey, securityToken);
    }

    public void setSecurityKey(ISecurityKey securityKey) {
        throw new UnsupportedOperationException("EnvironmentVariableObsCredentialsProvider class does not support this method");
    }

    public ISecurityKey getSecurityKey() {
        return this.securityKey;
    }

    private static String stringTrim(String value) {
        if (value == null) {
            return null;
        }
        return value.trim();
    }
}

