/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.io;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.io.InputStreamWrapper;
import com.obs.services.internal.io.InterruptableInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;

public class HttpMethodReleaseInputStream
extends InputStream
implements InputStreamWrapper {
    private static final ILogger interfaceLog = LoggerBuilder.getLogger("com.obs.services.internal.RestStorageService");
    private InputStream inputStream = null;
    private Response httpResponse = null;
    private boolean alreadyReleased = false;
    private boolean underlyingStreamConsumed = false;

    public HttpMethodReleaseInputStream(Response response) {
        this.httpResponse = response;
        try {
            this.inputStream = new InterruptableInputStream(response.body().byteStream());
        }
        catch (Exception e) {
            try {
                response.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = new ByteArrayInputStream(new byte[0]);
        }
    }

    public Response getHttpResponse() {
        return this.httpResponse;
    }

    protected void releaseConnection() throws IOException {
        if (!this.alreadyReleased) {
            if (!this.underlyingStreamConsumed && this.httpResponse != null) {
                this.httpResponse.close();
            }
            this.alreadyReleased = true;
        }
    }

    public int read() throws IOException {
        try {
            int read = this.inputStream.read();
            if (read == -1) {
                this.underlyingStreamConsumed = true;
                if (!this.alreadyReleased) {
                    this.releaseConnection();
                }
            }
            return read;
        }
        catch (IOException e) {
            try {
                this.releaseConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.inputStream.read(b, off, len);
            if (read == -1) {
                this.underlyingStreamConsumed = true;
                if (!this.alreadyReleased) {
                    this.releaseConnection();
                }
            }
            return read;
        }
        catch (IOException e) {
            try {
                this.releaseConnection();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw e;
        }
    }

    public int available() throws IOException {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            try {
                this.releaseConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public void close() throws IOException {
        if (!this.alreadyReleased) {
            this.releaseConnection();
        }
        this.inputStream.close();
    }

    protected void finalize() throws Throwable {
        if (!this.alreadyReleased) {
            if (interfaceLog.isWarnEnabled()) {
                interfaceLog.warn("Attempting to release HttpMethod in finalize() as its response data stream has gone out of scope. This attempt will not always succeed and cannot be relied upon! Please ensure response data streams are always fully consumed or closed to avoid HTTP connection starvation.");
            }
            this.releaseConnection();
            if (interfaceLog.isWarnEnabled()) {
                interfaceLog.warn("Successfully released HttpMethod in finalize(). You were lucky this time... Please ensure response data streams are always fully consumed or closed.");
            }
        }
        super.finalize();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

