/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import com.obs.services.internal.security.SecurityKey;
import com.obs.services.internal.utils.JSONChange;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class EcsSecurityUtils {
    private static final String OPENSTACK_METADATA_ROOT = "/openstack/latest";
    private static final String ECS_METADATA_SERIVCE_URL = "http://169.254.169.254";
    private static final String EC2_METADATA_SERVICE_OVERRIDE_URL = "ecsMetadataServiceOverrideEndpoint";
    private static final long HTTP_CONNECT_TIMEOUT_VALUE = 50000L;
    private static OkHttpClient httpClient = new OkHttpClient.Builder().followRedirects(false).retryOnConnectionFailure(false).cache(null).connectTimeout(50000L, TimeUnit.MILLISECONDS).writeTimeout(50000L, TimeUnit.MILLISECONDS).readTimeout(50000L, TimeUnit.MILLISECONDS).build();

    public static SecurityKey getSecurityKey() throws IOException {
        String securityKeyInfo = EcsSecurityUtils.getResource(EcsSecurityUtils.getEndpointForECSMetadataService() + OPENSTACK_METADATA_ROOT + "/securitykey");
        return (SecurityKey)JSONChange.jsonToObj(new SecurityKey(), securityKeyInfo);
    }

    public static String getEndpointForECSMetadataService() {
        String overridUrl = System.getProperty(EC2_METADATA_SERVICE_OVERRIDE_URL);
        return overridUrl != null ? overridUrl : ECS_METADATA_SERIVCE_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getResource(String endpoint) throws IOException {
        Request.Builder builder = new Request.Builder();
        builder.header("Accept", "*/*");
        Request request = builder.url(endpoint).get().build();
        Call c = httpClient.newCall(request);
        Response res = null;
        String content = new String();
        try {
            res = c.execute();
            if (res.body() != null) {
                content = res.body().string();
            }
            Object var7_6 = null;
            if (res == null) return content;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (res == null) throw throwable;
            res.close();
            throw throwable;
        }
        res.close();
        return content;
    }
}

