/*
 * Decompiled with CFR 0.152.
 */
package com.hydra.jres.handler;

import com.hydra.base.error.BusinessException;
import com.hydra.base.resp.ResultError;
import com.hydra.base.utils.JsonUtil;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FeignErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(FeignErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        try {
            InputStream is = response.body().asInputStream();
            String result = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            log.info(methodKey, (Object)result);
            String errorMessage = result;
            if (result.startsWith("{")) {
                ResultError error = (ResultError)JsonUtil.parseObject((String)result, ResultError.class);
                errorMessage = error.getMessage();
            }
            return new BusinessException(errorMessage);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6Feign\u7ed3\u679cIO\u6d41\u51fa\u9519", (Throwable)e);
            return e;
        }
    }
}

