/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor.pageinfo;

import com.google.common.collect.Lists;
import com.jfinal.aop.PrototypeInterceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.core.Controller;
import com.jfinal.ext.interceptor.pageinfo.PageInfo;
import com.jfinal.ext.interceptor.pageinfo.PageInfoKit;
import com.jfinal.ext.interceptor.pageinfo.RelationInfo;
import com.jfinal.ext.interceptor.pageinfo.RelationType;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Page;
import java.util.List;

public abstract class PageInfoInterceptor
extends PrototypeInterceptor {
    private boolean useColumnLabel = false;
    private String columns;
    private Class<? extends Model<?>> model;
    private List<RelationInfo> relations = Lists.newArrayList();

    public abstract void config();

    public PageInfoInterceptor setModel(Class<? extends Model<?>> model) {
        this.model = model;
        return this;
    }

    public PageInfoInterceptor addRelation(Class<? extends Model<?>> model, String condition, RelationType relationType) {
        this.relations.add(new RelationInfo(relationType, condition, model));
        return this;
    }

    public void doIntercept(ActionInvocation ai) {
        this.config();
        Controller controller = ai.getController();
        PageInfo pageInfo = PageInfoKit.injectPageInfo(this.model, controller, this.relations);
        this.extendsPageInfo(pageInfo);
        Page page = PageInfoKit.populate(pageInfo, this);
        controller.setAttr("pageInfo", (Object)pageInfo);
        controller.setAttr("page", (Object)page);
        ai.invoke();
    }

    public void extendsPageInfo(PageInfo pageInfo) {
    }

    public PageInfoInterceptor useColumnLabel(boolean useColumnLabel) {
        this.useColumnLabel = useColumnLabel;
        return this;
    }

    public boolean useColumnLabel() {
        return this.useColumnLabel;
    }

    public String columns() {
        return this.columns;
    }

    public PageInfoInterceptor columns(String columns) {
        this.columns = columns;
        return this;
    }

    public List<RelationInfo> relations() {
        return this.relations;
    }

    public PageInfoInterceptor relations(List<RelationInfo> relations) {
        this.relations = relations;
        return this;
    }

    public Class<? extends Model<?>> model() {
        return this.model;
    }
}

