/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.jms;

import com.jfinal.ext.plugin.jms.IMessageHandler;
import com.jfinal.ext.plugin.jms.ReceiveResolver;
import com.jfinal.ext.plugin.jms.ReceiveResolverFactory;
import com.jfinal.log.Logger;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class JmsReceive
implements IMessageHandler {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private ReceiveResolverFactory receiveResolverFactory;

    public JmsReceive(ReceiveResolverFactory receiveResolverFactory) {
        this.receiveResolverFactory = receiveResolverFactory;
    }

    @Override
    public void handleMessage(Message message) {
        try {
            int messageType = message.getIntProperty("msgType");
            ObjectMessage objMsg = (ObjectMessage)message;
            this.logger.debug("msgType " + messageType + " objMsg :" + objMsg);
            ReceiveResolver resolver = this.receiveResolverFactory.createReceiveResolver(new Integer(messageType));
            if (resolver == null) {
                this.logger.error("cant find  ReceiveResolver with messageType = " + messageType);
                return;
            }
            resolver.resolve(objMsg.getObject());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

