/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.jms;

import com.jfinal.ext.plugin.jms.QueueProducer;
import com.jfinal.ext.plugin.jms.TopicPublisher;
import com.jfinal.log.Logger;
import java.io.Serializable;
import java.util.Map;

public class JmsSender {
    protected final Logger logger = Logger.getLogger(this.getClass());
    Map<String, QueueProducer> queueProducers;
    Map<String, TopicPublisher> topicPublishers;

    public boolean queueSend(String queueName, Serializable message, int msgType) {
        if (this.queueProducers == null) {
            this.logger.error("JmsPlugin not start");
            return false;
        }
        QueueProducer queueProducer = this.queueProducers.get(queueName);
        this.logger.info("send msg " + message + "to queue " + queueName + " ,msgType " + msgType);
        return queueProducer.sendMessage(message, msgType);
    }

    public boolean topicSend(String topicName, Serializable message, int msgType) {
        if (this.topicPublishers == null) {
            this.logger.error("JmsPlugin not start");
            return false;
        }
        TopicPublisher topicPublisher = this.topicPublishers.get(topicName);
        this.logger.info("send msg " + message + "to topic" + topicName);
        return topicPublisher.publishMessage(message, msgType);
    }
}

