/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.redis;

import com.jfinal.ext.kit.ResourceKit;
import com.jfinal.ext.plugin.redis.JedisKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;

public class JedisPlugin
implements IPlugin {
    public JedisPool pool;
    private String config = "RedisConnector.properties";
    private String host = "localhost";
    private int port = 6379;
    private int timeout = 2000;
    private String password;
    private int maxactive = 8;
    private int maxidle = 8;
    private long maxwait = -1L;
    private long minevictableidletimemillis = 1800000L;
    private int minidle = 0;
    private int numtestsperevictionrun = 3;
    private long softminevictableidletimemillis = -1L;
    private long timebetweenevictionrunsmillis = -1L;
    private byte whenexhaustedaction = 1;
    private boolean testwhileidle = false;
    private boolean testonreturn = false;
    private boolean testonborrow = false;

    public JedisPlugin() {
    }

    public JedisPlugin(String host) {
        this.host = host;
    }

    public JedisPlugin(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public JedisPlugin(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public JedisPlugin config(String config) {
        this.config = config;
        return this;
    }

    public boolean start() {
        Map<String, String> map = ResourceKit.readProperties(this.config);
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            this.parseSetting(entry.getKey(), entry.getValue().trim());
        }
        JedisShardInfo shardInfo = new JedisShardInfo(this.host, this.port, this.timeout);
        if (StrKit.notBlank((String)this.password)) {
            shardInfo.setPassword(this.password);
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        this.setPoolConfig(poolConfig);
        this.pool = new JedisPool((GenericObjectPool.Config)poolConfig, shardInfo.getHost(), shardInfo.getPort(), shardInfo.getTimeout(), shardInfo.getPassword());
        JedisKit.init(this.pool);
        return true;
    }

    private void setPoolConfig(JedisPoolConfig poolConfig) {
        poolConfig.setMaxActive(this.maxactive);
        poolConfig.setMaxIdle(this.maxidle);
        poolConfig.setMaxWait(this.maxwait);
        poolConfig.setMinEvictableIdleTimeMillis(this.minevictableidletimemillis);
        poolConfig.setMinIdle(this.minidle);
        poolConfig.setNumTestsPerEvictionRun(this.numtestsperevictionrun);
        poolConfig.setSoftMinEvictableIdleTimeMillis(this.softminevictableidletimemillis);
        poolConfig.setTimeBetweenEvictionRunsMillis(this.timebetweenevictionrunsmillis);
        poolConfig.setWhenExhaustedAction(this.whenexhaustedaction);
        poolConfig.setTestWhileIdle(this.testwhileidle);
        poolConfig.setTestOnReturn(this.testonreturn);
        poolConfig.setTestOnBorrow(this.testonborrow);
    }

    public boolean stop() {
        try {
            this.pool.destroy();
        }
        catch (Exception ex) {
            System.err.println("Cannot properly close Jedis pool:" + ex);
        }
        this.pool = null;
        return true;
    }

    private void parseSetting(String key, String value) {
        if ("timeout".equalsIgnoreCase(key)) {
            this.timeout = Integer.valueOf(value);
        } else if ("password".equalsIgnoreCase(key)) {
            this.password = value;
        } else if ("host".equalsIgnoreCase(key)) {
            this.host = value;
        } else if ("maxactive".equalsIgnoreCase(key)) {
            this.maxactive = Integer.valueOf(value);
        } else if ("maxidle".equalsIgnoreCase(key)) {
            this.maxidle = Integer.valueOf(value);
        } else if ("maxwait".equalsIgnoreCase(key)) {
            this.maxwait = Integer.valueOf(value).intValue();
        } else if ("minevictableidletimemillis".equalsIgnoreCase(key)) {
            this.minevictableidletimemillis = Long.valueOf(value);
        } else if ("minidle".equalsIgnoreCase(key)) {
            this.minidle = Integer.valueOf(value);
        } else if ("numtestsperevictionrun".equalsIgnoreCase(key)) {
            this.numtestsperevictionrun = Integer.valueOf(value);
        } else if ("softminevictableidletimemillis".equalsIgnoreCase(key)) {
            this.softminevictableidletimemillis = Long.valueOf(value);
        } else if ("timebetweenevictionrunsmillis".equalsIgnoreCase(key)) {
            this.timebetweenevictionrunsmillis = Long.valueOf(value);
        } else if ("whenexhaustedaction".equalsIgnoreCase(key)) {
            if ("WHEN_EXHAUSTED_BLOCK".equalsIgnoreCase(value)) {
                this.whenexhaustedaction = 1;
            } else if ("WHEN_EXHAUSTED_FAIL".equalsIgnoreCase(value)) {
                this.whenexhaustedaction = 0;
            } else if ("WHEN_EXHAUSTED_GROW".equalsIgnoreCase(value)) {
                this.whenexhaustedaction = (byte)2;
            }
        } else if ("testwhileidle".equalsIgnoreCase(key)) {
            this.testwhileidle = Boolean.getBoolean(value);
        } else if ("testonreturn".equalsIgnoreCase(key)) {
            this.testonreturn = Boolean.getBoolean(value);
        } else if ("testonborrow".equalsIgnoreCase(key)) {
            this.testonborrow = Boolean.getBoolean(value);
        }
    }
}

