/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventDataUtil;
import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.IteratorUtil;
import com.microsoft.azure.servicebus.MessageSender;
import com.microsoft.azure.servicebus.MessagingFactory;
import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.StringUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;

public final class PartitionSender
extends ClientEntity {
    private final String partitionId;
    private final String eventHubName;
    private final MessagingFactory factory;
    private MessageSender internalSender;

    private PartitionSender(MessagingFactory factory, String eventHubName, String partitionId) {
        super(null);
        this.partitionId = partitionId;
        this.eventHubName = eventHubName;
        this.factory = factory;
    }

    static CompletableFuture<PartitionSender> Create(MessagingFactory factory, String eventHubName, String partitionId) throws ServiceBusException {
        final PartitionSender sender = new PartitionSender(factory, eventHubName, partitionId);
        return sender.createInternalSender().thenApplyAsync(new Function<Void, PartitionSender>(){

            @Override
            public PartitionSender apply(Void a) {
                return sender;
            }
        });
    }

    private CompletableFuture<Void> createInternalSender() throws ServiceBusException {
        return MessageSender.create(this.factory, StringUtil.getRandomString(), String.format("%s/Partitions/%s", this.eventHubName, this.partitionId)).thenAcceptAsync((Consumer)new Consumer<MessageSender>(){

            @Override
            public void accept(MessageSender a) {
                PartitionSender.this.internalSender = a;
            }
        });
    }

    public final void sendSync(EventData data) throws ServiceBusException {
        block5: {
            try {
                this.send(data).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                Throwable throwable;
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if ((throwable = exception.getCause()) == null) break block5;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
        }
    }

    public final CompletableFuture<Void> send(EventData data) throws ServiceBusException {
        return this.internalSender.send(data.toAmqpMessage());
    }

    public final void sendSync(Iterable<EventData> eventDatas) throws ServiceBusException {
        block5: {
            try {
                this.send(eventDatas).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                Throwable throwable;
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if ((throwable = exception.getCause()) == null) break block5;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
        }
    }

    public final CompletableFuture<Void> send(Iterable<EventData> eventDatas) throws ServiceBusException {
        if (eventDatas == null || IteratorUtil.sizeEquals(eventDatas, 0)) {
            throw new IllegalArgumentException("EventData batch cannot be empty.");
        }
        return this.internalSender.send(EventDataUtil.toAmqpMessages(eventDatas));
    }

    @Override
    public CompletableFuture<Void> close() {
        if (this.internalSender == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.internalSender.close();
    }
}

