/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientConstants;
import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.ErrorContext;
import com.microsoft.azure.servicebus.ExceptionUtil;
import com.microsoft.azure.servicebus.IErrorContextProvider;
import com.microsoft.azure.servicebus.MessagingFactory;
import com.microsoft.azure.servicebus.ReceiverContext;
import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.StringUtil;
import com.microsoft.azure.servicebus.TimeoutTracker;
import com.microsoft.azure.servicebus.Timer;
import com.microsoft.azure.servicebus.TimerType;
import com.microsoft.azure.servicebus.WorkItem;
import com.microsoft.azure.servicebus.amqp.AmqpConstants;
import com.microsoft.azure.servicebus.amqp.IAmqpReceiver;
import com.microsoft.azure.servicebus.amqp.ReceiveLinkHandler;
import com.microsoft.azure.servicebus.amqp.SessionHandler;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnknownDescribedType;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.Message;

public class MessageReceiver
extends ClientEntity
implements IAmqpReceiver,
IErrorContextProvider {
    private static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private static final int PING_FLOW_THRESHOLD = 2;
    private static final Duration RECEIVE_BATCH_INTERVAL = Duration.ofMillis(5L);
    private static final double FLOW_THRESHOLD_PERCENT = 0.3333333333333333;
    private static final int MAX_FLOW_DEFAULT = 32;
    private static final Duration MINIMUM_RECEIVE_TIMER = Duration.ofSeconds(2L);
    private static final int LINK_RESET_THRESHOLD = 3;
    private final ConcurrentLinkedQueue<WorkItem<Collection<Message>>> pendingReceives;
    private final MessagingFactory underlyingFactory;
    private final String name;
    private final String receivePath;
    private final Runnable onOperationTimedout;
    private final Duration operationTimeout;
    private int prefetchCount;
    private ConcurrentLinkedQueue<Message> prefetchedMessages;
    private Receiver receiveLink;
    private WorkItem<MessageReceiver> linkOpen;
    private CompletableFuture<Void> linkClose;
    private boolean closeCalled;
    private long epoch;
    private boolean isEpochReceiver;
    private Instant dateTime;
    private boolean offsetInclusive;
    private String lastReceivedOffset;
    private AtomicInteger pingFlowCount;
    private AtomicInteger currentFlow;
    private Instant lastCommunicatedAt;
    private boolean linkCreateScheduled;
    private Object linkCreateLock;
    private Exception lastKnownLinkError;
    private boolean onDeliveryTimerSet;
    private Object deliverySync;
    private int linkResetCount;

    private MessageReceiver(MessagingFactory factory, String name, String recvPath, String offset, boolean offsetInclusive, Instant dateTime, int prefetchCount, Long epoch, boolean isEpochReceiver) {
        super(name);
        this.underlyingFactory = factory;
        this.operationTimeout = factory.getOperationTimeout();
        this.name = name;
        this.receivePath = recvPath;
        this.prefetchCount = prefetchCount;
        this.epoch = epoch;
        this.isEpochReceiver = isEpochReceiver;
        this.prefetchedMessages = new ConcurrentLinkedQueue();
        this.pingFlowCount = new AtomicInteger();
        this.linkCreateLock = new Object();
        this.linkClose = new CompletableFuture();
        this.lastKnownLinkError = null;
        this.currentFlow = new AtomicInteger(0);
        this.onDeliveryTimerSet = false;
        this.deliverySync = new Object();
        this.linkResetCount = 0;
        if (offset != null) {
            this.lastReceivedOffset = offset;
            this.offsetInclusive = offsetInclusive;
        } else {
            this.dateTime = dateTime;
        }
        this.pendingReceives = new ConcurrentLinkedQueue();
        this.onOperationTimedout = new Runnable(){

            @Override
            public void run() {
                WorkItem topWorkItem = null;
                while ((topWorkItem = (WorkItem)MessageReceiver.this.pendingReceives.peek()) != null) {
                    if (topWorkItem.getTimeoutTracker().remaining().getSeconds() <= 0L) {
                        WorkItem dequedWorkItem = (WorkItem)MessageReceiver.this.pendingReceives.poll();
                        dequedWorkItem.getWork().complete(null);
                        continue;
                    }
                    MessageReceiver.this.scheduleOperationTimer(topWorkItem.getTimeoutTracker());
                    return;
                }
            }
        };
    }

    public static CompletableFuture<MessageReceiver> create(MessagingFactory factory, String name, String recvPath, String offset, boolean offsetInclusive, Instant dateTime, int prefetchCount, long epoch, boolean isEpochReceiver) {
        MessageReceiver msgReceiver = new MessageReceiver(factory, name, recvPath, offset, offsetInclusive, dateTime, prefetchCount, epoch, isEpochReceiver);
        return msgReceiver.createLink();
    }

    private CompletableFuture<MessageReceiver> createLink() {
        this.linkOpen = new WorkItem(new CompletableFuture(), this.operationTimeout);
        this.scheduleLinkOpenTimeout(this.linkOpen.getTimeoutTracker());
        this.linkCreateScheduled = true;
        Timer.schedule(new Runnable(){

            @Override
            public void run() {
                MessageReceiver.this.receiveLink = MessageReceiver.this.createReceiveLink();
            }
        }, Duration.ofSeconds(0L), TimerType.OneTimeRun);
        return this.linkOpen.getWork();
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchCount(int value) {
        int oldPrefetchCount = this.prefetchCount;
        this.prefetchCount = value;
        this.sendFlowInternal(value - oldPrefetchCount);
    }

    public final int getInitialPrefetchCount() {
        return this.prefetchCount > 2 ? this.prefetchCount - 2 : this.prefetchCount;
    }

    public CompletableFuture<Collection<Message>> receive() {
        if (this.receiveLink.getLocalState() == EndpointState.CLOSED) {
            this.scheduleRecreate(Duration.ofMillis(1L));
        }
        LinkedList<Message> returnMessages = null;
        Message currentMessage = null;
        while ((currentMessage = this.pollPrefetchQueue()) != null) {
            if (returnMessages == null) {
                returnMessages = new LinkedList<Message>();
            }
            returnMessages.add(currentMessage);
            if (returnMessages.size() < this.getInitialPrefetchCount()) continue;
        }
        if (returnMessages != null) {
            this.sendFlow(returnMessages.size());
            return CompletableFuture.completedFuture(returnMessages);
        }
        if (this.operationTimeout.compareTo(MINIMUM_RECEIVE_TIMER) <= 0) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.pendingReceives.isEmpty()) {
            this.scheduleOperationTimer(TimeoutTracker.create(this.operationTimeout));
        }
        CompletableFuture<Collection<Message>> onReceive = new CompletableFuture<Collection<Message>>();
        this.pendingReceives.offer(new WorkItem(onReceive, this.operationTimeout));
        this.sendPingFlow();
        return onReceive;
    }

    public int getPingFlowThreshold() {
        return this.prefetchCount > 2 ? 2 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpenComplete(Exception exception) {
        if (exception == null) {
            this.lastCommunicatedAt = Instant.now();
            if (this.linkOpen != null && !this.linkOpen.getWork().isDone()) {
                this.linkOpen.getWork().complete(this);
            }
            this.lastKnownLinkError = null;
            this.offsetInclusive = false;
            this.underlyingFactory.getRetryPolicy().resetRetryCount(this.underlyingFactory.getClientId());
            if (this.receiveLink.getCredit() == 0) {
                int pendingPrefetch = this.getInitialPrefetchCount() - this.prefetchedMessages.size();
                this.pingFlowCount.set(0);
                this.sendFlow(pendingPrefetch);
            }
        } else {
            if (this.linkOpen != null && !this.linkOpen.getWork().isDone()) {
                ExceptionUtil.completeExceptionally(this.linkOpen.getWork(), exception, this);
            }
            this.lastKnownLinkError = exception;
        }
        Object object = this.linkCreateLock;
        synchronized (object) {
            this.linkCreateScheduled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceiveComplete(Message message) {
        this.lastCommunicatedAt = Instant.now();
        this.prefetchedMessages.add(message);
        if (!this.onDeliveryTimerSet) {
            Object object = this.deliverySync;
            synchronized (object) {
                if (!this.onDeliveryTimerSet && !this.pendingReceives.isEmpty()) {
                    this.onDeliveryTimerSet = true;
                    Timer.schedule(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (MessageReceiver.this.prefetchedMessages.size() == 0) {
                                return;
                            }
                            WorkItem currentReceive = (WorkItem)MessageReceiver.this.pendingReceives.poll();
                            LinkedList<Message> returnMessages = null;
                            if (currentReceive != null) {
                                Message message = MessageReceiver.this.pollPrefetchQueue();
                                if (message != null) {
                                    returnMessages = new LinkedList<Message>();
                                    do {
                                        returnMessages.add(message);
                                    } while (returnMessages.size() < MessageReceiver.this.getInitialPrefetchCount() && (message = MessageReceiver.this.pollPrefetchQueue()) != null);
                                    MessageReceiver.this.sendFlow(returnMessages.size());
                                }
                                CompletableFuture future = currentReceive.getWork();
                                future.complete(returnMessages);
                            }
                            Object object = MessageReceiver.this.deliverySync;
                            synchronized (object) {
                                MessageReceiver.this.onDeliveryTimerSet = false;
                            }
                        }
                    }, RECEIVE_BATCH_INTERVAL, TimerType.OneTimeRun);
                }
            }
        }
        this.underlyingFactory.getRetryPolicy().resetRetryCount(this.getClientId());
    }

    public void onError(ErrorCondition error) {
        Exception completionException = ExceptionUtil.toException(error);
        this.onError(completionException);
    }

    @Override
    public void onError(Exception exception) {
        TimeoutTracker currentOperationTracker;
        WorkItem<Collection<Message>> currentReceive = this.pendingReceives.peek();
        TimeoutTracker timeoutTracker = currentReceive != null ? currentReceive.getTimeoutTracker() : (currentOperationTracker = this.linkOpen.getWork().isDone() ? null : this.linkOpen.getTimeoutTracker());
        Duration remainingTime = currentOperationTracker == null ? Duration.ofSeconds(0L) : (currentOperationTracker.elapsed().compareTo(this.operationTimeout) > 0 ? Duration.ofSeconds(0L) : this.operationTimeout.minus(currentOperationTracker.elapsed()));
        Duration retryInterval = this.underlyingFactory.getRetryPolicy().getNextRetryInterval(this.getClientId(), exception, remainingTime);
        if (retryInterval != null) {
            if (this.receiveLink.getLocalState() != EndpointState.CLOSED) {
                this.receiveLink.close();
            }
            this.scheduleRecreate(retryInterval);
            return;
        }
        this.onOpenComplete(exception);
        WorkItem<Collection<Message>> workItem = null;
        while ((workItem = this.pendingReceives.poll()) != null) {
            CompletableFuture<Collection<Message>> future = workItem.getWork();
            if (exception instanceof ServiceBusException && ((ServiceBusException)exception).getIsTransient()) {
                future.complete(null);
                continue;
            }
            ExceptionUtil.completeExceptionally(future, exception, this);
        }
    }

    private void scheduleOperationTimer(TimeoutTracker tracker) {
        if (tracker != null) {
            Timer.schedule(this.onOperationTimedout, tracker.remaining(), TimerType.OneTimeRun);
        }
    }

    private Receiver createReceiveLink() {
        Connection connection = null;
        try {
            connection = this.underlyingFactory.getConnection().get(this.operationTimeout.getSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable = exception.getCause();
            if (throwable != null && throwable instanceof Exception) {
                this.onError((Exception)exception.getCause());
            }
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return null;
        }
        catch (TimeoutException exception) {
            this.onError(new ServiceBusException(false, "Connection creation timed out.", exception));
            return null;
        }
        if (connection == null || connection.getLocalState() == EndpointState.CLOSED) {
            return null;
        }
        Source source = new Source();
        source.setAddress(this.receivePath);
        UnknownDescribedType filter = null;
        if (this.lastReceivedOffset == null) {
            long totalMilliSeconds;
            block12: {
                try {
                    totalMilliSeconds = this.dateTime.toEpochMilli();
                }
                catch (ArithmeticException ex) {
                    totalMilliSeconds = Long.MAX_VALUE;
                    if (!TRACE_LOGGER.isLoggable(Level.WARNING)) break block12;
                    TRACE_LOGGER.log(Level.WARNING, String.format("linkname[%s], linkPath[%s], warning[starting receiver from epoch+Long.Max]", this.receiveLink.getName(), this.receivePath, this.receiveLink.getCredit()));
                }
            }
            filter = new UnknownDescribedType((Object)AmqpConstants.STRING_FILTER, (Object)String.format("amqp.annotation.%s >%s '%s'", "x-opt-enqueued-time", "", totalMilliSeconds));
        } else {
            this.prefetchedMessages.clear();
            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, String.format("action[recreateReceiveLink], offset[%s], offsetInclusive[%s]", this.lastReceivedOffset, this.offsetInclusive));
            }
            filter = new UnknownDescribedType((Object)AmqpConstants.STRING_FILTER, (Object)String.format("amqp.annotation.%s >%s '%s'", "x-opt-offset", this.offsetInclusive ? "=" : "", this.lastReceivedOffset));
        }
        Map<Symbol, UnknownDescribedType> filterMap = Collections.singletonMap(AmqpConstants.STRING_FILTER, filter);
        source.setFilter(filterMap);
        Session session = connection.session();
        session.setIncomingCapacity(Integer.MAX_VALUE);
        session.open();
        BaseHandler.setHandler((Extendable)session, (Handler)new SessionHandler(this.receivePath));
        String receiveLinkName = StringUtil.getRandomString();
        receiveLinkName = receiveLinkName.concat("_").concat(connection.getRemoteContainer());
        Receiver receiver = session.receiver(receiveLinkName);
        receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)new Target());
        receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        receiver.setReceiverSettleMode(ReceiverSettleMode.SECOND);
        if (this.isEpochReceiver) {
            receiver.setProperties(Collections.singletonMap(AmqpConstants.EPOCH, this.epoch));
        }
        ReceiveLinkHandler handler = new ReceiveLinkHandler(this);
        BaseHandler.setHandler((Extendable)receiver, (Handler)handler);
        this.underlyingFactory.registerForConnectionError((Link)receiver);
        receiver.open();
        return receiver;
    }

    private Message pollPrefetchQueue() {
        Message message = this.prefetchedMessages.poll();
        if (message != null) {
            this.lastReceivedOffset = message.getMessageAnnotations().getValue().get(AmqpConstants.OFFSET).toString();
        }
        return message;
    }

    private void sendFlow(int credits) {
        if (this.receiveLink.getLocalState() != EndpointState.CLOSED) {
            int currentPingFlow = this.pingFlowCount.get();
            if (currentPingFlow > 0) {
                if (currentPingFlow < credits) {
                    this.sendFlowInternal(credits - currentPingFlow);
                    this.pingFlowCount.set(0);
                } else {
                    this.pingFlowCount.set(currentPingFlow - credits);
                }
            } else if (credits > 0) {
                this.sendFlowInternal(credits);
            }
        } else {
            this.scheduleRecreate(Duration.ofMillis(1L));
        }
    }

    private void sendFlowInternal(int credits) {
        int finalFlow = this.currentFlow.addAndGet(credits);
        int flowThreshold = (int)Math.min((double)this.getInitialPrefetchCount() * 0.3333333333333333, 32.0);
        if (finalFlow > 0 && finalFlow > flowThreshold) {
            this.receiveLink.flow(this.currentFlow.getAndSet(0));
            this.lastCommunicatedAt = Instant.now();
            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, String.format("linkname[%s], updated-link-credit[%s], sendCredits[%s]", this.receiveLink.getName(), this.receiveLink.getCredit(), finalFlow));
            }
        }
    }

    private void sendPingFlow() {
        if (this.receiveLink.getLocalState() != EndpointState.CLOSED) {
            if (this.pingFlowCount.get() < this.getPingFlowThreshold()) {
                if (Instant.now().isAfter(this.lastCommunicatedAt.plus(this.operationTimeout))) {
                    this.pingFlowCount.incrementAndGet();
                    this.receiveLink.flow(1);
                    this.lastCommunicatedAt = Instant.now();
                    if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                        TRACE_LOGGER.log(Level.FINE, String.format("linkname[%s], linkPath[%s], updated-link-credit[%s]", this.receiveLink.getName(), this.receivePath, this.receiveLink.getCredit()));
                    }
                } else {
                    this.sendFlowInternal(0);
                }
            } else if (this.receiveLink.getLocalState() != EndpointState.CLOSED) {
                String action = null;
                if (this.linkResetCount < 3) {
                    this.receiveLink.close();
                    action = "detectedReceiveStuck-closingLink";
                    ++this.linkResetCount;
                } else {
                    this.underlyingFactory.resetConnection();
                    this.linkResetCount = 0;
                }
                if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                    TRACE_LOGGER.log(Level.FINE, String.format("linkname[%s], linkPath[%s], linkCredit[%s], action[%s]", this.receiveLink.getName(), this.receivePath, this.receiveLink.getCredit(), action));
                }
            }
        } else {
            this.scheduleRecreate(Duration.ofMillis(1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRecreate(Duration runAfter) {
        Object object = this.linkCreateLock;
        synchronized (object) {
            if (this.linkCreateScheduled) {
                return;
            }
            this.linkCreateScheduled = true;
        }
        Timer.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (MessageReceiver.this.receiveLink.getLocalState() != EndpointState.CLOSED) {
                    return;
                }
                Receiver receiver = MessageReceiver.this.createReceiveLink();
                if (receiver != null) {
                    Receiver oldReceiver = MessageReceiver.this.receiveLink;
                    MessageReceiver.this.underlyingFactory.deregisterForConnectionError((Link)oldReceiver);
                    MessageReceiver.this.receiveLink = receiver;
                } else {
                    Object object = MessageReceiver.this.linkCreateLock;
                    synchronized (object) {
                        MessageReceiver.this.linkCreateScheduled = false;
                    }
                }
                MessageReceiver.this.underlyingFactory.getRetryPolicy().incrementRetryCount(MessageReceiver.this.getClientId());
            }
        }, runAfter, TimerType.OneTimeRun);
    }

    private void scheduleLinkOpenTimeout(TimeoutTracker timeout) {
        Timer.schedule(new Runnable(){

            @Override
            public void run() {
                if (!MessageReceiver.this.linkOpen.getWork().isDone()) {
                    Exception cause = MessageReceiver.this.lastKnownLinkError;
                    ServiceBusException operationTimedout = new ServiceBusException(cause != null && cause instanceof ServiceBusException ? ((ServiceBusException)cause).getIsTransient() : true, String.format(Locale.US, "ReceiveLink(%s) %s() on path(%s) timed out", MessageReceiver.this.receiveLink.getName(), "Open", MessageReceiver.this.receivePath), cause);
                    if (TRACE_LOGGER.isLoggable(Level.WARNING)) {
                        TRACE_LOGGER.log(Level.WARNING, String.format(Locale.US, "message recever(linkName: %s, path: %s) %s call timedout", MessageReceiver.this.receiveLink.getName(), MessageReceiver.this.receivePath, "Open"), operationTimedout);
                    }
                    ExceptionUtil.completeExceptionally(MessageReceiver.this.linkOpen.getWork(), operationTimedout, MessageReceiver.this);
                }
            }
        }, timeout.remaining(), TimerType.OneTimeRun);
    }

    private void scheduleLinkCloseTimeout(TimeoutTracker timeout) {
        Timer.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompletableFuture completableFuture = MessageReceiver.this.linkClose;
                synchronized (completableFuture) {
                    if (!MessageReceiver.this.linkClose.isDone()) {
                        TimeoutException operationTimedout = new TimeoutException(String.format(Locale.US, "Receive Link(%s) %s() timed out", MessageReceiver.this.receiveLink.getName(), "Close"));
                        if (TRACE_LOGGER.isLoggable(Level.WARNING)) {
                            TRACE_LOGGER.log(Level.WARNING, String.format(Locale.US, "message recever(linkName: %s, path: %s) %s call timedout", MessageReceiver.this.receiveLink.getName(), MessageReceiver.this.receivePath, "Close"), operationTimedout);
                        }
                        ExceptionUtil.completeExceptionally(MessageReceiver.this.linkClose, operationTimedout, MessageReceiver.this);
                    }
                }
            }
        }, timeout.remaining(), TimerType.OneTimeRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(ErrorCondition condition) {
        CompletableFuture<Void> completableFuture = this.linkClose;
        synchronized (completableFuture) {
            if (this.closeCalled) {
                this.linkClose.complete(null);
                this.closeCalled = false;
                return;
            }
        }
        if (condition == null) {
            this.onError(new ServiceBusException(true, String.format(Locale.US, "Closing the link. LinkName(%s), EntityPath(%s)", this.receiveLink.getName(), this.receivePath)));
        } else {
            this.onError(condition);
        }
    }

    @Override
    public CompletableFuture<Void> close() {
        this.closeInternal();
        return this.linkClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal() {
        CompletableFuture<Void> completableFuture = this.linkClose;
        synchronized (completableFuture) {
            if (!this.closeCalled) {
                if (this.receiveLink != null && this.receiveLink.getLocalState() != EndpointState.CLOSED) {
                    this.receiveLink.close();
                    this.scheduleLinkCloseTimeout(TimeoutTracker.create(this.operationTimeout));
                    this.closeCalled = true;
                } else {
                    this.linkClose.complete(null);
                }
            }
        }
    }

    @Override
    public ErrorContext getContext() {
        boolean isLinkOpened;
        boolean bl = isLinkOpened = this.linkOpen != null && this.linkOpen.getWork().isDone();
        String referenceId = this.receiveLink != null && this.receiveLink.getRemoteProperties() != null && this.receiveLink.getRemoteProperties().containsKey(ClientConstants.TRACKING_ID_PROPERTY) ? this.receiveLink.getRemoteProperties().get(ClientConstants.TRACKING_ID_PROPERTY).toString() : (this.receiveLink != null ? this.receiveLink.getName() : null);
        ReceiverContext errorContext = new ReceiverContext(this.underlyingFactory != null ? this.underlyingFactory.getHostName() : null, this.receivePath, referenceId, isLinkOpened ? new Long(this.lastReceivedOffset) : null, isLinkOpened ? Integer.valueOf(this.prefetchCount) : null, isLinkOpened ? Integer.valueOf(this.receiveLink.getCredit()) : null, isLinkOpened && this.prefetchedMessages != null ? Integer.valueOf(this.prefetchedMessages.size()) : null, this.isEpochReceiver);
        return errorContext;
    }
}

