/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientConstants;
import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.IConnectionFactory;
import com.microsoft.azure.servicebus.RetryPolicy;
import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.StringUtil;
import com.microsoft.azure.servicebus.TimeoutTracker;
import com.microsoft.azure.servicebus.amqp.BaseLinkHandler;
import com.microsoft.azure.servicebus.amqp.ConnectionHandler;
import com.microsoft.azure.servicebus.amqp.IAmqpConnection;
import com.microsoft.azure.servicebus.amqp.ReactorHandler;
import java.io.IOException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.reactor.Reactor;

public class MessagingFactory
extends ClientEntity
implements IAmqpConnection,
IConnectionFactory {
    public static final Duration DefaultOperationTimeout = Duration.ofSeconds(60L);
    private static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private final Object connectionLock = new Object();
    private final String hostName;
    private Reactor reactor;
    private Thread reactorThread;
    private ConnectionHandler connectionHandler;
    private Connection connection;
    private boolean waitingConnectionOpen;
    private Duration operationTimeout;
    private RetryPolicy retryPolicy;
    private CompletableFuture<MessagingFactory> open;
    private CompletableFuture<Connection> openConnection;
    private LinkedList<Link> registeredLinks;
    private TimeoutTracker connectionCreateTracker;

    MessagingFactory(ConnectionStringBuilder builder) throws IOException {
        super("MessagingFactory".concat(StringUtil.getRandomString()));
        this.hostName = builder.getEndpoint().getHost();
        this.startReactor(new ReactorHandler(){

            @Override
            public void onReactorFinal(Event e) {
                super.onReactorFinal(e);
                MessagingFactory.this.onReactorError(new ServiceBusException(true, "Reactor finalized."));
            }
        });
        this.operationTimeout = builder.getOperationTimeout();
        this.retryPolicy = builder.getRetryPolicy();
        this.registeredLinks = new LinkedList();
    }

    String getHostName() {
        return this.hostName;
    }

    private void createConnection(ConnectionStringBuilder builder) {
        assert (this.reactor != null);
        this.connectionHandler = new ConnectionHandler(this, builder.getEndpoint().getHost(), builder.getSasKeyName(), builder.getSasKey());
        this.waitingConnectionOpen = true;
        this.connection = this.reactor.connection((Handler)this.connectionHandler);
        this.open = new CompletableFuture();
    }

    private void startReactor(ReactorHandler reactorHandler) throws IOException {
        this.reactor = Proton.reactor((Handler[])new Handler[]{reactorHandler});
        this.reactorThread = new Thread(new RunReactor(this.reactor));
        this.reactorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Connection> getConnection() {
        if (this.connection.getLocalState() == EndpointState.CLOSED || this.connectionCreateTracker != null && this.connectionCreateTracker.remaining().minus(ClientConstants.TIMER_TOLERANCE).isNegative()) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connection.getLocalState() == EndpointState.CLOSED && !this.waitingConnectionOpen || this.connectionCreateTracker != null && this.connectionCreateTracker.remaining().minus(ClientConstants.TIMER_TOLERANCE).isNegative()) {
                    try {
                        this.startReactor(new ReactorHandler(){

                            @Override
                            public void onReactorInit(Event e) {
                                super.onReactorInit(e);
                                Reactor reactor = e.getReactor();
                                MessagingFactory.this.connection = reactor.connection((Handler)MessagingFactory.this.connectionHandler);
                            }

                            @Override
                            public void onReactorFinal(Event e) {
                                super.onReactorFinal(e);
                                MessagingFactory.this.onReactorError(new ServiceBusException(true, "Reactor finalized."));
                            }
                        });
                    }
                    catch (IOException e) {
                        this.onReactorError(new ServiceBusException(true, (Throwable)e));
                    }
                    if (this.openConnection != null && !this.openConnection.isDone()) {
                        this.openConnection.completeExceptionally(new ServiceBusException(false, "Connection creation timedout."));
                    }
                    this.openConnection = new CompletableFuture();
                    this.connectionCreateTracker = TimeoutTracker.create(this.operationTimeout);
                    this.waitingConnectionOpen = true;
                }
            }
        }
        return this.openConnection == null ? CompletableFuture.completedFuture(this.connection) : this.openConnection;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString) throws IOException {
        ConnectionStringBuilder builder = new ConnectionStringBuilder(connectionString);
        MessagingFactory messagingFactory = new MessagingFactory(builder);
        messagingFactory.createConnection(builder);
        return messagingFactory.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpenComplete(Exception exception) {
        Object object = this.connectionLock;
        synchronized (object) {
            this.waitingConnectionOpen = false;
        }
        if (exception == null) {
            this.open.complete(this);
            if (this.openConnection != null) {
                this.openConnection.complete(this.connection);
            }
        } else {
            this.open.completeExceptionally(exception);
            if (this.openConnection != null) {
                this.openConnection.completeExceptionally(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectionError(ErrorCondition error) {
        Connection currentConnection = this.connection;
        for (Link link : this.registeredLinks) {
            if (link.getLocalState() == EndpointState.CLOSED) continue;
            link.close();
        }
        try {
            if (currentConnection.getLocalState() != EndpointState.CLOSED) {
                currentConnection.close();
            }
            for (Link link : this.registeredLinks) {
                Handler handler = BaseHandler.getHandler((Extendable)link);
                if (handler == null || !(handler instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, error);
            }
        }
        finally {
            currentConnection.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReactorError(Exception cause) {
        if (!this.open.isDone()) {
            this.onOpenComplete(cause);
            return;
        }
        Connection currentConnection = this.connection;
        for (Link link : this.registeredLinks) {
            if (link.getLocalState() == EndpointState.CLOSED) continue;
            link.close();
        }
        try {
            if (currentConnection != null && currentConnection.getLocalState() != EndpointState.CLOSED) {
                currentConnection.close();
            }
            for (Link link : this.registeredLinks) {
                Handler handler = BaseHandler.getHandler((Extendable)link);
                if (handler == null || !(handler instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, cause);
            }
        }
        finally {
            currentConnection.free();
        }
    }

    void resetConnection() {
        this.onReactorError(new ServiceBusException(true, "Client invoked connection reset."));
    }

    @Override
    public void closeSync() {
        if (this.connection != null) {
            if (this.connection.getLocalState() != EndpointState.CLOSED) {
                this.connection.close();
            }
            this.connection.free();
        }
    }

    @Override
    public CompletableFuture<Void> close() {
        this.closeSync();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void registerForConnectionError(Link link) {
        this.registeredLinks.add(link);
    }

    @Override
    public void deregisterForConnectionError(Link link) {
        this.registeredLinks.remove(link);
    }

    private class RunReactor
    implements Runnable {
        private Reactor r;

        public RunReactor(Reactor r) {
            this.r = r;
        }

        @Override
        public void run() {
            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, "starting reactor instance.");
            }
            try {
                this.r.run();
            }
            catch (HandlerException handlerException) {
                HandlerException cause = handlerException;
                if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                    TRACE_LOGGER.log(Level.WARNING, "UnHandled exception while processing events in reactor:");
                    TRACE_LOGGER.log(Level.FINE, handlerException.getMessage());
                    if (handlerException.getStackTrace() != null) {
                        for (StackTraceElement ste : handlerException.getStackTrace()) {
                            TRACE_LOGGER.log(Level.FINE, ste.toString());
                        }
                    }
                }
                MessagingFactory.this.onReactorError(new ServiceBusException(true, (Throwable)cause));
            }
        }
    }
}

