/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientConstants;
import com.microsoft.azure.servicebus.RetryExponential;
import com.microsoft.azure.servicebus.ServiceBusException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RetryPolicy {
    private static final RetryPolicy NO_RETRY = new RetryExponential(Duration.ofSeconds(0L), Duration.ofSeconds(0L), 0);
    private ConcurrentHashMap<String, Integer> retryCounts = new ConcurrentHashMap();

    protected RetryPolicy() {
    }

    public void incrementRetryCount(String clientId) {
        Integer retryCount = this.retryCounts.get(clientId);
        this.retryCounts.put(clientId, retryCount == null ? 1 : retryCount + 1);
    }

    public void resetRetryCount(String clientId) {
        Integer currentRetryCount = this.retryCounts.get(clientId);
        if (currentRetryCount != null && currentRetryCount != 0) {
            this.retryCounts.put(clientId, 0);
        }
    }

    public static boolean isRetryableException(Exception exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception cannot be null");
        }
        if (exception instanceof ServiceBusException) {
            return ((ServiceBusException)exception).getIsTransient();
        }
        return false;
    }

    public static RetryPolicy getDefault() {
        return new RetryExponential(ClientConstants.DEFAULT_RERTRY_MIN_BACKOFF, ClientConstants.DEFAULT_RERTRY_MAX_BACKOFF, 10);
    }

    public static RetryPolicy getNoRetry() {
        return NO_RETRY;
    }

    protected int getRetryCount(String clientId) {
        Integer retryCount = this.retryCounts.get(clientId);
        return retryCount == null ? 0 : retryCount;
    }

    public abstract Duration getNextRetryInterval(String var1, Exception var2, Duration var3);
}

