/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.TimerType;
import java.time.Duration;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class Timer {
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Math.min(Runtime.getRuntime().availableProcessors(), 2));

    private Timer() {
    }

    public static void schedule(Runnable runnable, Duration runFrequency, TimerType timerType) {
        switch (timerType) {
            case OneTimeRun: {
                long seconds = runFrequency.getSeconds();
                if (seconds > 0L) {
                    executor.schedule(runnable, seconds, TimeUnit.SECONDS);
                    break;
                }
                executor.schedule(runnable, runFrequency.toMillis(), TimeUnit.MILLISECONDS);
                break;
            }
            case RepeatRun: {
                executor.scheduleWithFixedDelay(runnable, runFrequency.getSeconds(), runFrequency.getSeconds(), TimeUnit.SECONDS);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported timer pattern.");
            }
        }
    }
}

