/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.EventData;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.apache.qpid.proton.message.Message;

final class EventDataUtil {
    private EventDataUtil() {
    }

    static LinkedList<EventData> toEventDataCollection(Collection<Message> messages) {
        if (messages == null) {
            return null;
        }
        LinkedList<EventData> events = new LinkedList<EventData>();
        for (Message message : messages) {
            events.add(new EventData(message));
        }
        return events;
    }

    static Iterable<Message> toAmqpMessages(Iterable<EventData> eventDatas, final String partitionKey) {
        final LinkedList<Message> messages = new LinkedList<Message>();
        eventDatas.forEach(new Consumer<EventData>(){

            @Override
            public void accept(EventData eventData) {
                Message amqpMessage = partitionKey == null ? eventData.toAmqpMessage() : eventData.toAmqpMessage(partitionKey);
                messages.add(amqpMessage);
            }
        });
        return messages;
    }

    static Iterable<Message> toAmqpMessages(Iterable<EventData> eventDatas) {
        return EventDataUtil.toAmqpMessages(eventDatas, null);
    }
}

