/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.common_utils;

import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.UnknownException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPathUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonPathUtils.class);
    private static final String PATH_DELIMITER = "/";

    public static String encodeRemotePath(String urlPath) throws AbstractCosException {
        String[] pathSegmentsArr;
        StringBuilder pathBuilder = new StringBuilder();
        for (String pathSegment : pathSegmentsArr = urlPath.split(PATH_DELIMITER)) {
            if (pathSegment.trim().isEmpty()) continue;
            try {
                pathBuilder.append(PATH_DELIMITER).append(URLEncoder.encode(pathSegment.trim(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                String errMsg = "Unsupported ecnode exception:" + e.toString();
                LOG.error(errMsg);
                throw new UnknownException(errMsg);
            }
        }
        if (urlPath.endsWith(PATH_DELIMITER)) {
            pathBuilder.append(PATH_DELIMITER);
        }
        return pathBuilder.toString();
    }
}

