/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.meta.FileAuthority;
import com.qcloud.cos.meta.InsertOnly;
import com.qcloud.cos.request.CreateFolderRequest;
import com.qcloud.cos.request.DelFileRequest;
import com.qcloud.cos.request.DelFolderRequest;
import com.qcloud.cos.request.ListFolderRequest;
import com.qcloud.cos.request.MoveFileRequest;
import com.qcloud.cos.request.StatFileRequest;
import com.qcloud.cos.request.StatFolderRequest;
import com.qcloud.cos.request.UpdateFileRequest;
import com.qcloud.cos.request.UpdateFolderRequest;
import com.qcloud.cos.request.UploadFileRequest;

public class Demo {
    public static void main(String[] args) throws Exception {
        int appId = 1000000;
        String secretId = "xxxxxxxxxxxxxxxxx";
        String secretKey = "xxxxxxxxxxxxxxxxx";
        COSClient cosClient = new COSClient(appId, secretId, secretKey);
        String bucketName = "mybucket";
        String cosFilePath = "/sample_file.txt";
        String localFilePath1 = "src/test/resources/local_file_1.txt";
        UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, cosFilePath, localFilePath1);
        String uploadFileRet = cosClient.uploadFile(uploadFileRequest);
        System.out.println("upload file ret:" + uploadFileRet);
        String localFilePath2 = "src/test/resources/local_file_2.txt";
        UploadFileRequest overWriteFileRequest = new UploadFileRequest(bucketName, cosFilePath, localFilePath2);
        overWriteFileRequest.setInsertOnly(InsertOnly.OVER_WRITE);
        String overWriteFileRet = cosClient.uploadFile(overWriteFileRequest);
        System.out.println("overwrite file ret:" + overWriteFileRet);
        StatFileRequest statFileRequest = new StatFileRequest(bucketName, cosFilePath);
        String statFileRet = cosClient.statFile(statFileRequest);
        System.out.println("stat file ret:" + statFileRet);
        UpdateFileRequest updateFileRequest = new UpdateFileRequest(bucketName, cosFilePath);
        updateFileRequest.setBizAttr("\u6d4b\u8bd5\u76ee\u5f55");
        updateFileRequest.setAuthority(FileAuthority.WPRIVATE);
        updateFileRequest.setCacheControl("no cache");
        updateFileRequest.setContentDisposition("cos_sample.txt");
        updateFileRequest.setContentLanguage("english");
        updateFileRequest.setContentType("application/json");
        updateFileRequest.setXCosMeta("x-cos-meta-xxx", "xxx");
        updateFileRequest.setXCosMeta("x-cos-meta-yyy", "yyy");
        String updateFileRet = cosClient.updateFile(updateFileRequest);
        System.out.println("update file ret:" + updateFileRet);
        statFileRet = cosClient.statFile(statFileRequest);
        System.out.println("stat file ret:" + statFileRet);
        String moveFilePath = "/sample_file_move.txt";
        MoveFileRequest moveFileRequest = new MoveFileRequest(bucketName, cosFilePath, moveFilePath);
        String moveFileRet = cosClient.moveFile(moveFileRequest);
        System.out.println("move file ret:" + moveFileRet);
        DelFileRequest delFileRequest = new DelFileRequest(bucketName, moveFilePath);
        String delFileRet = cosClient.delFile(delFileRequest);
        System.out.println("del file ret:" + delFileRet);
        String cosFolderPath = "/xxsample_folder/";
        CreateFolderRequest createFolderRequest = new CreateFolderRequest(bucketName, cosFolderPath);
        String createFolderRet = cosClient.createFolder(createFolderRequest);
        System.out.println("create folder ret:" + createFolderRet);
        UpdateFolderRequest updateFolderRequest = new UpdateFolderRequest(bucketName, cosFolderPath);
        updateFolderRequest.setBizAttr("\u8fd9\u662f\u4e00\u4e2a\u6d4b\u8bd5\u76ee\u5f55");
        String updateFolderRet = cosClient.updateFolder(updateFolderRequest);
        System.out.println("update folder ret:" + updateFolderRet);
        StatFolderRequest statFolderRequest = new StatFolderRequest(bucketName, cosFolderPath);
        String statFolderRet = cosClient.statFolder(statFolderRequest);
        System.out.println("stat folder ret:" + statFolderRet);
        ListFolderRequest listFolderRequest = new ListFolderRequest(bucketName, cosFolderPath);
        String listFolderRet = cosClient.listFolder(listFolderRequest);
        System.out.println("list folder ret:" + listFolderRet);
        DelFolderRequest delFolderRequest = new DelFolderRequest(bucketName, cosFolderPath);
        String delFolderRet = cosClient.delFolder(delFolderRequest);
        System.out.println("del folder ret:" + delFolderRet);
        cosClient.shutdown();
        System.out.println("shutdown!");
    }
}

