/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.meta;

import com.qcloud.cos.common_utils.CommonFileUtils;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.UnknownException;
import com.qcloud.cos.meta.FileStat;
import com.qcloud.cos.meta.SlicePart;
import com.qcloud.cos.meta.UploadSliceFileContext;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class SliceCheckPoint
implements Serializable {
    private static final long serialVersionUID = -5759346251314490168L;
    public static final String DEFAULT_MAGIC = "B61BAAF89E3FD039F1279C4440AD8A7F0250300E";
    public int hashDigest = 0;
    public String magic = null;
    public String cosPath = null;
    public String uploadFile = null;
    public FileStat uploadFileStat = null;
    public String sessionId = null;
    public boolean enableShaDigest = true;
    public String shaDigest = null;
    public int sliceSize = 0;
    public ArrayList<SlicePart> sliceParts = null;
    public boolean initFlag = false;
    public boolean serialUpload = true;

    private void assign(SliceCheckPoint scp) {
        this.magic = scp.magic;
        this.hashDigest = scp.hashDigest;
        this.cosPath = scp.cosPath;
        this.uploadFile = scp.uploadFile;
        this.uploadFileStat = scp.uploadFileStat;
        this.enableShaDigest = scp.enableShaDigest;
        this.shaDigest = scp.shaDigest;
        this.sessionId = scp.sessionId;
        this.sliceParts = scp.sliceParts;
        this.initFlag = scp.initFlag;
        this.serialUpload = scp.serialUpload;
        this.sliceSize = scp.sliceSize;
    }

    public int hashCode() {
        int hashValue = 1;
        int prime = 31;
        hashValue = 31 * hashValue + (this.magic == null ? 0 : this.magic.hashCode());
        hashValue = 31 * hashValue + (this.cosPath == null ? 0 : this.cosPath.hashCode());
        hashValue = 31 * hashValue + (this.uploadFile == null ? 0 : this.uploadFile.hashCode());
        hashValue = 31 * hashValue + (this.uploadFileStat == null ? 0 : this.uploadFileStat.hashCode());
        hashValue = 31 * hashValue + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        hashValue = 31 * hashValue + (this.shaDigest == null ? 0 : this.shaDigest.hashCode());
        hashValue = 31 * hashValue + (this.sliceParts == null ? 0 : this.sliceParts.hashCode());
        hashValue = 31 * hashValue + this.sliceSize;
        hashValue = 31 * hashValue + new Boolean(this.initFlag).hashCode();
        hashValue = 31 * hashValue + new Boolean(this.serialUpload).hashCode();
        hashValue = 31 * hashValue + new Boolean(this.enableShaDigest).hashCode();
        return hashValue;
    }

    public synchronized void updateAfterInit(UploadSliceFileContext context) throws AbstractCosException {
        try {
            this.sessionId = context.getSessionId();
            this.enableShaDigest = context.isEnableShaDigest();
            this.shaDigest = context.getEntireFileSha();
            this.initFlag = true;
            this.serialUpload = context.isSerialUpload();
            if (context.isEnableSavePoint()) {
                this.dump(context.getSavePointFile());
            }
        }
        catch (IOException e) {
            throw new UnknownException(e.getMessage());
        }
    }

    public synchronized void update(int sliceIndex, boolean uploadCompleted) {
        this.sliceParts.get(sliceIndex).setUploadCompleted(uploadCompleted);
    }

    public synchronized void load(String scpFile) throws IOException, ClassNotFoundException {
        FileInputStream fileIn = new FileInputStream(scpFile);
        ObjectInputStream objIn = new ObjectInputStream(fileIn);
        SliceCheckPoint scp = (SliceCheckPoint)objIn.readObject();
        this.assign(scp);
        objIn.close();
        fileIn.close();
    }

    public synchronized void dump(String scpFile) throws IOException {
        this.hashDigest = this.hashCode();
        FileOutputStream fileOut = new FileOutputStream(scpFile);
        ObjectOutputStream objOut = new ObjectOutputStream(fileOut);
        objOut.writeObject(this);
        objOut.close();
        fileOut.close();
    }

    public synchronized boolean isValid(String uploadFile) throws AbstractCosException {
        if (this.magic == null || !this.magic.equals(DEFAULT_MAGIC) || this.hashDigest != this.hashCode()) {
            return false;
        }
        if (!CommonFileUtils.isLegalFile(uploadFile)) {
            return false;
        }
        if (!this.uploadFile.equals(uploadFile)) {
            return false;
        }
        try {
            if (this.uploadFileStat.getFileSize() != CommonFileUtils.getFileLength(uploadFile)) {
                return false;
            }
            if (this.uploadFileStat.getLastModifiedTime() != CommonFileUtils.getFileLastModified(uploadFile)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new UnknownException(e.getMessage());
        }
        return true;
    }
}

