/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.op;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.common_utils.CommonCodecUtils;
import com.qcloud.cos.common_utils.CommonFileUtils;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.ParamException;
import com.qcloud.cos.exception.UnknownException;
import com.qcloud.cos.http.AbstractCosHttpClient;
import com.qcloud.cos.http.HttpContentType;
import com.qcloud.cos.http.HttpMethod;
import com.qcloud.cos.http.HttpRequest;
import com.qcloud.cos.meta.FileStat;
import com.qcloud.cos.meta.SliceCheckPoint;
import com.qcloud.cos.meta.SliceFileDataTask;
import com.qcloud.cos.meta.SlicePart;
import com.qcloud.cos.meta.UploadSliceFileContext;
import com.qcloud.cos.op.BaseOp;
import com.qcloud.cos.request.DelFileRequest;
import com.qcloud.cos.request.GetFileInputStreamRequest;
import com.qcloud.cos.request.GetFileLocalRequest;
import com.qcloud.cos.request.StatFileRequest;
import com.qcloud.cos.request.UpdateFileRequest;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.request.UploadSliceFileRequest;
import com.qcloud.cos.sign.Credentials;
import com.qcloud.cos.sign.Sign;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOp
extends BaseOp {
    private static final Logger LOG = LoggerFactory.getLogger(FileOp.class);

    public FileOp(ClientConfig config, Credentials cred, AbstractCosHttpClient client) {
        super(config, cred, client);
    }

    private String buildGetFileUrl(GetFileInputStreamRequest request) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.config.getDownCosEndPointPrefix()).append(request.getBucketName()).append("-").append(this.cred.getAppId()).append(".");
        if (request.isUseCDN()) {
            strBuilder.append("file.myqcloud.com");
        } else {
            strBuilder.append(this.config.getDownCosEndPointDomain());
        }
        strBuilder.append(request.getCosPath()).toString();
        String url = strBuilder.toString();
        return url;
    }

    public String updateFile(UpdateFileRequest request) throws AbstractCosException {
        request.check_param();
        String url = this.buildUrl(request);
        String sign = Sign.getOneEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("Content-Type", "application/json");
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "update");
        int updateFlag = request.getUpdateFlag();
        if ((updateFlag & 1) != 0) {
            httpRequest.addParam("biz_attr", request.getBizAttr());
        }
        if ((updateFlag & 0x40) != 0) {
            String customHeaderStr = new JSONObject(request.getCustomHeaders()).toString();
            httpRequest.addParam("custom_headers", customHeaderStr);
        }
        if ((updateFlag & 0x80) != 0) {
            httpRequest.addParam("authority", request.getAuthority().toString());
        }
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String delFile(DelFileRequest request) throws AbstractCosException {
        return super.delBase(request);
    }

    public String statFile(StatFileRequest request) throws AbstractCosException {
        return super.statBase(request);
    }

    public String uploadFile(UploadFileRequest request) throws AbstractCosException {
        request.check_param();
        String localPath = request.getLocalPath();
        long fileSize = 0L;
        if (request.isUploadFromBuffer()) {
            fileSize = request.getContentBufer().length;
        } else {
            try {
                fileSize = CommonFileUtils.getFileLength(localPath);
            }
            catch (Exception e) {
                throw new UnknownException(e.toString());
            }
        }
        long suitSingleFileSize = 0x800000L;
        if (fileSize < suitSingleFileSize) {
            return this.uploadSingleFile(request);
        }
        UploadSliceFileRequest sliceRequest = new UploadSliceFileRequest(request);
        sliceRequest.setInsertOnly(request.getInsertOnly());
        if (request.isUploadFromBuffer()) {
            sliceRequest.setContentBufer(request.getContentBufer());
        }
        sliceRequest.setEnableSavePoint(request.isEnableSavePoint());
        sliceRequest.setEnableShaDigest(request.isEnableShaDigest());
        sliceRequest.setTaskNum(request.getTaskNum());
        return this.uploadSliceFile(sliceRequest);
    }

    public String uploadSingleFile(UploadFileRequest request) throws AbstractCosException {
        request.check_param();
        String localPath = request.getLocalPath();
        long fileSize = 0L;
        if (request.isUploadFromBuffer()) {
            fileSize = request.getContentBufer().length;
        } else {
            try {
                fileSize = CommonFileUtils.getFileLength(localPath);
            }
            catch (Exception e) {
                throw new UnknownException(e.toString());
            }
        }
        if (fileSize > 0x1400000L) {
            throw new ParamException("file is to big, please use uploadFile interface!");
        }
        String fileContent = "";
        String shaDigest = "";
        try {
            if (request.isUploadFromBuffer()) {
                fileContent = new String(request.getContentBufer(), Charset.forName("ISO-8859-1"));
                shaDigest = CommonCodecUtils.getBufferSha1(request.getContentBufer());
            } else {
                fileContent = CommonFileUtils.getFileContent(localPath);
                shaDigest = CommonCodecUtils.getEntireFileSha1(localPath);
            }
        }
        catch (Exception e) {
            throw new UnknownException(e.toString());
        }
        String url = this.buildUrl(request);
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred, signExpired);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "upload");
        httpRequest.addParam("sha", shaDigest);
        httpRequest.addParam("biz_attr", request.getBizAttr());
        httpRequest.addParam("fileContent", fileContent);
        httpRequest.addParam("insertOnly", String.valueOf(request.getInsertOnly().ordinal()));
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String uploadSliceFile(UploadSliceFileRequest request) throws AbstractCosException {
        request.check_param();
        UploadSliceFileContext context = new UploadSliceFileContext(request);
        context.setUrl(this.buildUrl(request));
        return this.uploadFileWithCheckPoint(context);
    }

    private String uploadFileWithCheckPoint(UploadSliceFileContext context) throws AbstractCosException {
        SliceCheckPoint scp = new SliceCheckPoint();
        if (context.isEnableSavePoint()) {
            try {
                scp.load(context.getSavePointFile());
            }
            catch (Exception e) {
                CommonFileUtils.remove(context.getSavePointFile());
            }
            if (!scp.isValid(context.getLocalPath())) {
                CommonFileUtils.remove(context.getSavePointFile());
                this.prepare(context, scp);
            }
        }
        JSONObject uploadResult = this.upload(context, scp);
        if (context.isEnableSavePoint() && uploadResult.getInt("code") == 0) {
            CommonFileUtils.remove(context.getSavePointFile());
        }
        return uploadResult.toString();
    }

    private void prepare(UploadSliceFileContext context, SliceCheckPoint scp) throws AbstractCosException {
        try {
            long fileSize = 0L;
            if (context.isUploadFromBuffer()) {
                fileSize = context.getContentBuffer().length;
            } else {
                try {
                    fileSize = CommonFileUtils.getFileLength(context.getLocalPath());
                    scp.uploadFile = context.getLocalPath();
                    scp.uploadFileStat = FileStat.getFileStat(scp.uploadFile);
                }
                catch (Exception e) {
                    throw new UnknownException(e.toString());
                }
            }
            int sliceSize = context.getSliceSize();
            scp.magic = "B61BAAF89E3FD039F1279C4440AD8A7F0250300E";
            scp.cosPath = context.getCosPath();
            scp.sessionId = context.getSessionId();
            scp.enableShaDigest = context.isEnableSavePoint();
            scp.sliceParts = this.splitFile(fileSize, sliceSize);
            scp.initFlag = false;
        }
        catch (Exception e) {
            throw new UnknownException(e.getMessage());
        }
    }

    private ArrayList<SlicePart> splitFile(long fileSize, int sliceSize) {
        ArrayList<SlicePart> sliceParts = new ArrayList<SlicePart>();
        int sliceCount = new Long((fileSize + (long)(sliceSize - 1)) / (long)sliceSize).intValue();
        for (int sliceIndex = 0; sliceIndex < sliceCount; ++sliceIndex) {
            SlicePart part = new SlicePart();
            long offset = Long.valueOf(sliceIndex) * (long)sliceSize;
            part.setOffset(offset);
            if (sliceIndex != sliceCount - 1) {
                part.setSliceSize(sliceSize);
            } else {
                part.setSliceSize(new Long(fileSize - offset).intValue());
            }
            part.setUploadCompleted(false);
            sliceParts.add(part);
        }
        return sliceParts;
    }

    private void recover(UploadSliceFileContext context, SliceCheckPoint scp) throws AbstractCosException {
        try {
            long fileSize = CommonFileUtils.getFileLength(context.getLocalPath());
            context.setFileSize(fileSize);
            context.setSessionId(scp.sessionId);
            context.setEntireFileSha(scp.shaDigest);
            context.setEnableShaDigest(scp.enableShaDigest);
            context.setSliceSize(scp.sliceSize);
        }
        catch (Exception e) {
            throw new UnknownException(e.getMessage());
        }
    }

    private JSONObject upload(UploadSliceFileContext context, SliceCheckPoint scp) throws AbstractCosException {
        if (!scp.initFlag) {
            JSONObject initResult = this.sendSliceInit(context);
            if (initResult.getInt("code") != 0) {
                return initResult;
            }
            JSONObject data = initResult.getJSONObject("data");
            if (data.has("access_url")) {
                return initResult;
            }
            if (data.has("serial_upload") && data.getInt("serial_upload") == 1) {
                LOG.debug("SERIAL_UPLOAD is true");
                context.setSerialUpload(true);
            } else {
                LOG.debug("SERIAL_UPLOAD is false");
                context.setSerialUpload(false);
            }
            context.setSessionId(data.getString("session"));
            if (data.getInt("slice_size") != context.getSliceSize()) {
                context.setSliceSize(data.getInt("slice_size"));
            }
            this.prepare(context, scp);
            scp.updateAfterInit(context);
        } else {
            this.recover(context, scp);
        }
        JSONObject sendParallelRet = this.sendSliceDataParallel(context, scp);
        if (sendParallelRet.getInt("code") != 0) {
            return sendParallelRet;
        }
        JSONObject finishRet = this.sendSliceFinish(context);
        return finishRet;
    }

    private JSONObject sendSliceInit(UploadSliceFileContext context) throws AbstractCosException {
        String localPath = context.getLocalPath();
        long fileSize = 0L;
        try {
            fileSize = context.isUploadFromBuffer() ? (long)context.getContentBuffer().length : CommonFileUtils.getFileLength(localPath);
            context.setFileSize(fileSize);
        }
        catch (Exception e) {
            throw new UnknownException(e.toString());
        }
        int sliceSize = context.getSliceSize();
        StringBuilder entireDigestSb = new StringBuilder();
        String slicePartDigest = "";
        try {
            if (context.isEnableShaDigest()) {
                slicePartDigest = context.isUploadFromBuffer() ? CommonCodecUtils.getSlicePartSha1(context.getContentBuffer(), sliceSize, entireDigestSb) : CommonCodecUtils.getSlicePartSha1(localPath, sliceSize, entireDigestSb);
                context.setEntireFileSha(entireDigestSb.toString());
                LOG.debug("slicePartDigest: " + slicePartDigest);
            }
        }
        catch (Exception e) {
            throw new UnknownException(e.getMessage());
        }
        String url = context.getUrl();
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(context.getBucketName(), context.getCosPath(), this.cred, signExpired);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("filesize", String.valueOf(fileSize));
        httpRequest.addParam("slice_size", String.valueOf(sliceSize));
        httpRequest.addParam("op", "upload_slice_init");
        httpRequest.addParam("insertOnly", String.valueOf(context.getInsertOnly().ordinal()));
        if (context.isEnableShaDigest()) {
            httpRequest.addParam("sha", entireDigestSb.toString());
            httpRequest.addParam("uploadparts", slicePartDigest);
        }
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        JSONObject resultJson = null;
        String resultStr = this.httpClient.sendHttpRequest(httpRequest);
        LOG.debug("sendSliceInit, resultStr: " + resultStr);
        resultJson = new JSONObject(resultStr);
        return resultJson;
    }

    private JSONObject sendSliceDataParallel(UploadSliceFileContext context, SliceCheckPoint scp) throws AbstractCosException {
        ArrayList<Future<JSONObject>> allSliceTasks = new ArrayList<Future<JSONObject>>();
        int threadNum = 1;
        if (!context.isSerialUpload()) {
            threadNum = context.getTaskNum();
        }
        ExecutorService service = Executors.newFixedThreadPool(threadNum);
        String url = context.getUrl();
        long signExpired = this.config.getSignExpired();
        for (int sliceIndex = 0; sliceIndex < scp.sliceParts.size(); ++sliceIndex) {
            if (scp.sliceParts.get(sliceIndex).isUploadCompleted()) continue;
            SliceFileDataTask dataTask = new SliceFileDataTask(sliceIndex, sliceIndex, scp, context, this.httpClient, this.cred, url, signExpired);
            allSliceTasks.add(service.submit(dataTask));
        }
        service.shutdown();
        try {
            service.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            service.shutdownNow();
        }
        catch (Exception e) {
            throw new UnknownException(e.getMessage());
        }
        JSONObject taskResult = null;
        if (allSliceTasks.size() == 0) {
            taskResult = new JSONObject();
            taskResult.put("code", 0);
            return taskResult;
        }
        for (Future future : allSliceTasks) {
            try {
                taskResult = (JSONObject)future.get();
            }
            catch (Exception e) {
                throw new UnknownException(e.getMessage());
            }
            if (taskResult.getInt("code") == 0) continue;
            return taskResult;
        }
        return taskResult;
    }

    private JSONObject sendSliceFinish(UploadSliceFileContext context) throws AbstractCosException {
        String url = context.getUrl();
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(context.getBucketName(), context.getCosPath(), this.cred, signExpired);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("session", context.getSessionId());
        httpRequest.addParam("op", "upload_slice_finish");
        if (context.isEnableShaDigest()) {
            httpRequest.addParam("sha", context.getEntireFileSha());
        }
        httpRequest.addParam("filesize", String.valueOf(context.getFileSize()));
        httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        httpRequest.setMethod(HttpMethod.POST);
        JSONObject resultJson = null;
        String resultStr = this.httpClient.sendHttpRequest(httpRequest);
        resultJson = new JSONObject(resultStr);
        LOG.debug("sendSliceFinish, resultStr: " + resultStr);
        return resultJson;
    }

    public String getFileLocal(GetFileLocalRequest request) throws AbstractCosException {
        InputStream in = this.getFileInputStream(request);
        BufferedInputStream bis = new BufferedInputStream(in);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(request.getLocalPath()));
        }
        catch (FileNotFoundException e) {
            throw new UnknownException(e.getMessage());
        }
        BufferedOutputStream bos = new BufferedOutputStream(out);
        try {
            int inByte;
            while ((inByte = bis.read()) != -1) {
                bos.write(inByte);
            }
        }
        catch (IOException e) {
            throw new UnknownException(e.getMessage());
        }
        finally {
            try {
                bis.close();
                bos.close();
            }
            catch (IOException e) {
                throw new UnknownException(e.getMessage());
            }
        }
        JSONObject retJson = new JSONObject();
        retJson.put("code", 0);
        retJson.put("message", (Object)"SUCCESS");
        return retJson.toString();
    }

    public InputStream getFileInputStream(GetFileInputStreamRequest request) throws AbstractCosException {
        String url = this.buildGetFileUrl(request);
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred, signExpired);
        StringBuilder rangeBuilder = new StringBuilder();
        if (request.getRangeStart() != 0L || request.getRangeEnd() != Long.MAX_VALUE) {
            rangeBuilder.append("bytes=").append(request.getRangeStart()).append("-");
            rangeBuilder.append(request.getRangeEnd());
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        if (!rangeBuilder.toString().isEmpty()) {
            httpRequest.addHeader("Range", rangeBuilder.toString());
        }
        if (!request.getReferer().isEmpty()) {
            httpRequest.addHeader("Referer", request.getReferer());
        }
        httpRequest.addParam("sign", sign);
        return this.httpClient.getFileInputStream(httpRequest);
    }
}

