/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.cdn;

import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class CdnManager {
    private final Auth auth;
    private final String server;
    private final Client client;

    public CdnManager(Auth auth) {
        this(auth, "http://fusion.qiniuapi.com");
    }

    private CdnManager(Auth auth, String server) {
        this.auth = auth;
        this.server = server;
        this.client = new Client(null, false, null, 10, 30, 0);
    }

    public Response refreshUrls(String[] urls) throws QiniuException {
        return this.refreshUrlsAndDirs(urls, null);
    }

    public Response refreshDirs(String[] dirs) throws QiniuException {
        return this.refreshUrlsAndDirs(null, dirs);
    }

    public Response refreshUrlsAndDirs(String[] urls, String[] dirs) throws QiniuException {
        HashMap<String, String[]> req = new HashMap<String, String[]>();
        if (urls != null) {
            req.put("urls", urls);
        }
        if (dirs != null) {
            req.put("dirs", dirs);
        }
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/refresh";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        return this.client.post(url, body, headers, "application/json");
    }

    public Response prefetchUrls(String[] urls) throws QiniuException {
        HashMap<String, String[]> req = new HashMap<String, String[]>();
        req.put("urls", urls);
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/prefetch";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        return this.client.post(url, body, headers, "application/json");
    }

    public Response getBandwidthData(String[] domains, String startDate, String endDate, String granularity) throws QiniuException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("domains", StringUtils.join(domains, ";"));
        req.put("startDate", startDate);
        req.put("endDate", endDate);
        req.put("granularity", granularity);
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/bandwidth";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        return this.client.post(url, body, headers, "application/json");
    }

    public Response getFluxData(String[] domains, String startDate, String endDate, String granularity) throws QiniuException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("domains", StringUtils.join(domains, ";"));
        req.put("startDate", startDate);
        req.put("endDate", endDate);
        req.put("granularity", granularity);
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/flux";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        return this.client.post(url, body, headers, "application/json");
    }

    public Response getCdnLogList(String[] domains, String logDate) throws QiniuException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("domains", StringUtils.join(domains, ";"));
        req.put("day", logDate);
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/log/list";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        return this.client.post(url, body, headers, "application/json");
    }

    public static String createTimestampAntiLeechUrl(String host, String fileName, StringMap queryStringMap, String encryptKey, long deadline) throws UnsupportedEncodingException, MalformedURLException, NoSuchAlgorithmException {
        String urlToSign;
        if (queryStringMap != null && queryStringMap.size() > 0) {
            ArrayList<String> queryStrings = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : queryStringMap.map().entrySet()) {
                StringBuilder queryStringBuilder = new StringBuilder();
                queryStringBuilder.append(URLEncoder.encode(entry.getKey(), "utf-8"));
                queryStringBuilder.append("=");
                queryStringBuilder.append(URLEncoder.encode(entry.getValue().toString(), "utf-8"));
                queryStrings.add(queryStringBuilder.toString());
            }
            urlToSign = String.format("%s/%s?%s", host, URLEncoder.encode(fileName, "utf-8"), StringUtils.join(queryStrings, "&"));
        } else {
            urlToSign = String.format("%s/%s", host, URLEncoder.encode(fileName, "utf-8"));
        }
        URL urlObj = new URL(urlToSign);
        String path = urlObj.getPath();
        String expireHex = Long.toHexString(deadline);
        String toSignStr = String.format("%s%s%s", encryptKey, path, expireHex);
        String signedStr = StringUtils.md5Lower(toSignStr);
        String signedUrl = urlObj.getQuery() != null ? String.format("%s&sign=%s&t=%s", urlToSign, signedStr, expireHex) : String.format("%s?sign=%s&t=%s", urlToSign, signedStr, expireHex);
        return signedUrl;
    }
}

