/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.common.ZoneReqInfo;
import com.qiniu.http.ProxyConfiguration;
import qiniu.happydns.DnsClient;

public final class Configuration
implements Cloneable {
    private final Zone zone;
    public boolean uploadByHttps = false;
    public int putThreshold = 0x400000;
    public int connectTimeout = 10;
    public int writeTimeout = 0;
    public int responseTimeout = 30;
    public int retryMax = 5;
    public DnsClient dns = null;
    public boolean dnsHostFirst = false;
    public ProxyConfiguration proxy = null;

    public Configuration(Zone zone) {
        this.zone = zone;
    }

    public Configuration clone() {
        try {
            return (Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String upHost(String upToken) throws QiniuException {
        if (this.uploadByHttps) {
            return this.zone.getUpHttps(new ZoneReqInfo(upToken));
        }
        return this.zone.getUpHttp(new ZoneReqInfo(upToken));
    }

    public String upHostBackup(String upToken) throws QiniuException {
        if (this.uploadByHttps) {
            return this.zone.getUpBackupHttps(new ZoneReqInfo(upToken));
        }
        return this.zone.getUpBackupHttp(new ZoneReqInfo(upToken));
    }

    public String rsfHost(String ak, String bucket) {
        if (this.uploadByHttps) {
            return this.zone.getRsfHttps(new ZoneReqInfo(ak, bucket));
        }
        return this.zone.getRsfHttp(new ZoneReqInfo(ak, bucket));
    }

    public String rsHost(String ak, String bucket) {
        if (this.uploadByHttps) {
            return this.zone.getRsHttps(new ZoneReqInfo(ak, bucket));
        }
        return this.zone.getRsHttp(new ZoneReqInfo(ak, bucket));
    }

    public String rsBucketsHost() {
        if (this.uploadByHttps) {
            return "https://rs.qbox.me";
        }
        return "http://rs.qiniu.com";
    }

    public String ioHost(String ak, String bucket) {
        if (this.uploadByHttps) {
            return this.zone.getIovipHttps(new ZoneReqInfo(ak, bucket));
        }
        return this.zone.getIovipHttp(new ZoneReqInfo(ak, bucket));
    }

    public String apiHost(String ak, String bucket) {
        if (this.uploadByHttps) {
            return this.zone.getApiHttps(new ZoneReqInfo(ak, bucket));
        }
        return this.zone.getApiHttp(new ZoneReqInfo(ak, bucket));
    }
}

