package com.roco.settle.api.enums;

import com.roco.settle.api.response.base.CommonResponse;
import lombok.Getter;


/**
 * @author Andrew
 * @create 2020/2/4 8:58 下午
 */
public enum ResponseEnum {
    SUCCESS("000000","成功"),
    NEED_LOGIN("400001", "登录已失效"),
    PARAM_ERROR("500001", "参数异常"),
    BIZ_ERROR("888888","业务异常"),
    SYSTEM_ERROR("999999","系统异常");

    ResponseEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Getter
    private String code;

    @Getter
    private String message;

    public static boolean isSuccess(CommonResponse response){
        if (response != null && SUCCESS.getCode().equals(response.getCode())) {
            return true;
        }
        return false;
    }
}
