package com.roco.settle.api.response.base;

import com.roco.settle.api.enums.ResponseEnum;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author Andrew
 * @create 2020/2/4 8:58 下午
 */
@Accessors(chain = true)
@NoArgsConstructor
@ToString(callSuper = true)
@Data
public class CommonQueryPageResponse<T> extends CommonResponse<T> {
    private long total;
    private int pages;

    private static CommonQueryPageResponse getResponse(ResponseEnum responseCode) {
        CommonQueryPageResponse response = new CommonQueryPageResponse();
        response.setCode(responseCode.getCode());
        response.setMessage(responseCode.getMessage());
        return response;
    }

    public static CommonQueryPageResponse success(List result, long total, int pages) {
        CommonQueryPageResponse response = getResponse(ResponseEnum.SUCCESS);
        response.setTotal(total);
        response.setPages(pages);
        response.setResult(result);
        return response ;
    }
}
