package com.roco.settle.api.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/2/19 15:16</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Setter
@Getter
public class SettleEnterpriseServiceApplyItem implements Serializable {
    /**
     * id
     */
    @Id
    private Integer id;

    /**
     * 申请单编码
     */
    private String applyNo;

    /**
     * 明细编码
     */
    private String detailNo;

    /**
     * 业务基点编码
     */
    private String enterpriseCode;

    /**
     * 业务基点简称
     */
    @Transient
    private String enterpriseSimpleName;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;
    /**
     * 业务主体简称
     */
    @Transient
    private String bizSubjectSimpleName;

    /**
     * 保险启保日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone ="GMT+08:00")
    private LocalDate insuranceStartdate;

    /**
     * 保单号
     */
    private String insuranceNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 车型号
     */
    private String carModel;

    /**
     * 被保人姓名
     */
    private String insurantUserName;

    /**
     * 服务套餐金额
     */
    private BigDecimal servicePackageAmount;

    /**
     * 服务套餐名称
     */
    private String servicePackageName;

    /**
     * 服务项目编码
     */
    private String serviceItemCode;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 状态
     */
    private String status;


    /**
     * 版本
     */
    private Integer revision;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 创建人名称
     */
    private String createName;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone ="GMT+08:00")
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private Integer updateUser;

    /**
     * 更新人名称
     */
    private String updateName;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone ="GMT+08:00")
    private LocalDateTime updateTime;

    /**
     * 供应商编码
     */
    private String supplierCode;
    /**
     * 结算价
     */
    private BigDecimal settlePrice;

    /**
     * 使用订单号
     */
    private String useOrderNo;


}