package com.roco.settle.api.entity;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import com.roco.settle.api.enums.SettlePaymentApplyStatusEnum;
import com.roco.settle.api.enums.SettlePaymentApplyTypeEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务主体支付工单(SettlePaymentApply)实体类
 *
 * @author hsf
 * @since 2020-02-25 09:08:06
 */
@Data
@Table(name = "settle_payment_apply")
public class SettlePaymentApply implements Serializable {

   
    @Id
    private Integer id;

    /**
     * 申请单号  
     */
    private String applyNo;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 供应商简称  
     */
    private String supplierSimpleName;

    /**
     * 供应商编码  
     */
    private String supplierCode;

    /**
     * 支付总金额(元)  
     */
    private BigDecimal amount;

    /**
     * 结算事项类型
     */
    @Column(name = "type")
    private SettlePaymentApplyTypeEnum type;

    /**
     * 结算工单  
     */
    private String settleOrderNo;

    /**
     * 工单状态  
     */
    @Column(name = "status")
    private SettlePaymentApplyStatusEnum status;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String updateUser;

    private String updateName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate updateDate;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

   

}